% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy.R
\name{copy.SDTree}
\alias{copy.SDTree}
\title{Copy a tree}
\usage{
\method{copy}{SDTree}(object, ...)
}
\arguments{
\item{object}{an SDTree object}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A copy of the SDTree object
}
\description{
Returns a copy of the tree object. 
Might be useful if you want to keep the original tree in comparison to the pruned tree.
}
\examples{

set.seed(1)
X <- matrix(rnorm(10 * 20), nrow = 10)
Y <- rnorm(10)
fit <- SDTree(x = X, y = Y, cp = 0.5)
fit2 <- copy(fit)
}
\seealso{
\code{\link{prune}}
}
\author{
Markus Ulmer
}
