% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_FeaturePlot.R
\name{do_FeaturePlot}
\alias{do_FeaturePlot}
\title{Wrapper for \link[Seurat]{FeaturePlot}.}
\usage{
do_FeaturePlot(
  sample,
  features,
  assay = NULL,
  reduction = NULL,
  slot = NULL,
  order = TRUE,
  split.by = NULL,
  split.by.idents = NULL,
  cells.highlight = NULL,
  idents.highlight = NULL,
  dims = c(1, 2),
  enforce_symmetry = FALSE,
  pt.size = 1,
  font.size = 14,
  font.type = "sans",
  legend.title = NULL,
  legend.type = "colorbar",
  legend.position = "bottom",
  legend.framewidth = 1.5,
  legend.tickwidth = 1.5,
  legend.length = 20,
  legend.width = 1,
  legend.framecolor = "grey50",
  legend.tickcolor = "white",
  plot.title = NULL,
  plot.subtitle = NULL,
  plot.caption = NULL,
  individual.titles = NULL,
  individual.subtitles = NULL,
  individual.captions = NULL,
  ncol = NULL,
  viridis_color_map = "G",
  viridis_direction = 1,
  raster = FALSE,
  raster.dpi = 1024,
  plot_cell_borders = TRUE,
  border.size = 2,
  border.color = "black",
  na.value = "grey75",
  verbose = TRUE,
  plot.axes = FALSE
)
}
\arguments{
\item{sample}{\strong{\code{\link[SeuratObject]{Seurat}}} | A Seurat object, generated by \link[Seurat]{CreateSeuratObject}.}

\item{features}{\strong{\code{\link[base]{character}}} | Features to represent.}

\item{assay}{\strong{\code{\link[base]{character}}} | Assay to use. Defaults to the current assay.}

\item{reduction}{\strong{\code{\link[base]{character}}} | Reduction to use. Can be the canonical ones such as "umap", "pca", or any custom ones, such as "diffusion". If you are unsure about which reductions you have, use \code{Seurat::Reductions(sample)}. Defaults to "umap" if present or to the last computed reduction if the argument is not provided.}

\item{slot}{\strong{\code{\link[base]{character}}} | Data slot to use. Only one of: counts, data, scale.data. Defaults to "data".}

\item{order}{\strong{\code{\link[base]{logical}}} | Whether to order the cells based on expression.}

\item{split.by}{\strong{\code{\link[base]{character}}} | Secondary metadata variable to further group (split) the output by. Has to be a character of factor column.}

\item{split.by.idents}{\strong{\code{\link[base]{character}}} | Vector of identities to plot. The gradient scale will also be subset to only the values of such identities.}

\item{cells.highlight, idents.highlight}{\strong{\code{\link[base]{character}}} | Vector of cells/identities to focus into. The identities have to much those in \code{Seurat::Idents(sample)} The rest of the cells will be grayed out. Both parameters can be used at the same time.}

\item{dims}{\strong{\code{\link[base]{numeric}}} | Vector of 2 numerics indicating the dimensions to plot out of the selected reduction. Defaults to c(1, 2) if not specified.}

\item{enforce_symmetry}{\strong{\code{\link[base]{logical}}} | Return a symmetrical plot axes-wise or continuous color scale-wise, when applicable.}

\item{pt.size}{\strong{\code{\link[base]{numeric}}} | Size of the dots.}

\item{font.size}{\strong{\code{\link[base]{numeric}}} | Overall font size of the plot. All plot elements will have a size relationship with this font size.}

\item{font.type}{\strong{\code{\link[base]{character}}} | Base font family for the plot. One of:
\itemize{
\item \emph{\code{mono}}: Mono spaced font.
\item \emph{\code{serif}}: Serif font family.
\item \emph{\code{sans}}: Default font family.
}}

\item{legend.title}{\strong{\code{\link[base]{character}}} | Title for the legend.}

\item{legend.type}{\strong{\code{\link[base]{character}}} | Type of legend to display. One of:
\itemize{
\item \emph{\code{normal}}: Default legend displayed by \pkg{ggplot2}.
\item \emph{\code{colorbar}}: Redefined colorbar legend, using \link[ggplot2]{guide_colorbar}.
\item \emph{\code{colorsteps}}: Redefined legend with colors going by range, in steps, using \link[ggplot2]{guide_colorsteps}.
}}

\item{legend.position}{\strong{\code{\link[base]{character}}} | Position of the legend in the plot. One of:
\itemize{
\item \emph{\code{top}}: Top of the figure.
\item \emph{\code{bottom}}: Bottom of the figure.
\item \emph{\code{left}}: Left of the figure.
\item \emph{\code{right}}: Right of the figure.
\item \emph{\code{none}}: No legend is displayed.
}}

\item{legend.framewidth, legend.tickwidth}{\strong{\code{\link[base]{numeric}}} | Width of the lines of the box in the legend.}

\item{legend.length, legend.width}{\strong{\code{\link[base]{numeric}}} | Length and width of the legend. Will adjust automatically depending on legend side.}

\item{legend.framecolor}{\strong{\code{\link[base]{character}}} | Color of the lines of the box in the legend.}

\item{legend.tickcolor}{\strong{\code{\link[base]{character}}} | Color of the ticks of the box in the legend.}

\item{plot.title, plot.subtitle, plot.caption}{\strong{\code{\link[base]{character}}} | Title, subtitle or caption to use in the plot.}

\item{individual.titles, individual.subtitles, individual.captions}{\strong{\code{\link[base]{character}}} | Titles or subtitles. for each feature if needed. Either NULL or a vector of equal length of features.}

\item{ncol}{\strong{\code{\link[base]{numeric}}} | Number of columns used in the arrangement of the output plot using "split.by" parameter.}

\item{viridis_color_map}{\strong{\code{\link[base]{character}}} | A capital letter from A to H or the scale name as in \link[viridis]{scale_fill_viridis}.}

\item{viridis_direction}{\strong{\code{\link[base]{numeric}}} | Either 1 or -1. Controls how the gradient of viridis scale is formed.}

\item{raster}{\strong{\code{\link[base]{logical}}} | Whether to raster the resulting plot. This is recommendable if plotting a lot of cells.}

\item{raster.dpi}{\strong{\code{\link[base]{numeric}}} | Pixel resolution for rasterized plots. Defaults to 1024.}

\item{plot_cell_borders}{\strong{\code{\link[base]{logical}}} | Whether to plot border around cells.}

\item{border.size}{\strong{\code{\link[base]{numeric}}} | Width of the border of the cells.}

\item{border.color}{\strong{\code{\link[base]{character}}} | Color to use for the border of the cells.}

\item{na.value}{\strong{\code{\link[base]{character}}} | Color value for NA.}

\item{verbose}{\strong{\code{\link[base]{logical}}} | Whether to show extra comments, warnings,etc.}

\item{plot.axes}{\strong{\code{\link[base]{logical}}} | Whether to plot axes or not.}
}
\value{
A ggplot2 object containing a Feature Plot.
}
\description{
Wrapper for \link[Seurat]{FeaturePlot}.
}
\examples{
\donttest{
  # Define your Seurat object.
  sample <- readRDS(system.file("extdata/seurat_dataset_example.rds", package = "SCpubr"))

  # Regular FeaturePlot.
  p <- SCpubr::do_FeaturePlot(sample = sample,
                              features = "nCount_RNA")

  # Add a title, subtitle and caption.
  p <- SCpubr::do_FeaturePlot(sample = sample,
                              features = "nCount_RNA",
                              plot.title = "Number of UMIs",
                              plot.subtitle = "Number of unique mRNAs per cell.",
                              plot.caption = "Plot generated using SCpubr.")

  # Add a subtitle.
  p <- SCpubr::do_FeaturePlot(sample = sample,
                              features = "nCount_RNA",
                              plot.title = "Number of UMIs",
                              plot.subtitle = "Number of unique mRNAs per cell.")

  # Add a caption
  p <- SCpubr::do_FeaturePlot(sample = sample,
                              features = "nCount_RNA",
                              plot.title = "Number of UMIs",
                              plot.subtitle = "Number of unique mRNAs per cell.",
                              plot.caption = "Plot generated using SCpubr.")

  # Plot multiple features and control the output columns.
  p <- SCpubr::do_FeaturePlot(sample, features = c("nCount_RNA",
                                                   "nFeature_RNA",
                                                   "EPC1"),
                              plot.title = "My very important features",
                              ncol = 3)

  # FeaturePlot with a subset of cells maintaining the original UMAP shape.
  cells.plot <- colnames(sample[, !(sample$seurat_clusters \%in\% c("2", "5", "8"))])
  p <- SCpubr::do_FeaturePlot(sample = sample,
                              cells.highlight = cells.plot,
                              features = c("EPC1"))

  # FeaturePlot with a subset of identities
  # (in Seurat::Idents(sample)) maintaining the original UMAP shape.
  idents.use <- levels(sample)[!(levels(sample) \%in\% c("2", "5", "8"))]
  p <- SCpubr::do_FeaturePlot(sample = sample,
                              idents.highlight = idents.use,
                              features = c("EPC1"))

  # Splitting the FeaturePlot by a variable and
  # maintaining the color scale and the UMAP shape.
  p <- SCpubr::do_FeaturePlot(sample = sample,
                              features = "EPC1",
                              split.by = "seurat_clusters")

  # Splitting the FeaturePlot by a variable
  # and subset only some of the unique groups.
  p <- SCpubr::do_FeaturePlot(sample,
                              features = c("EPC1", "nCount_RNA", "PC_1"),
                              split.by = "seurat_clusters",
                              split.by.idents = c("2", "5"))

  # Modify the viridis color maps.
  p <- SCpubr::do_FeaturePlot(sample = sample,
                              features = "EPC1",
                              viridis_color_map = "A",
                              plot.title = "Magma")
}
}
