% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatReg_GoF.R
\name{SpatReg_GoF}
\alias{SpatReg_GoF}
\title{Computes a set of goodness-of-fit indices (e.g., likelihood-based information criteria, Wald and LR test, Moran's I statistic) for a given spatial regression model of class \code{lm} or \code{Sarlm}.}
\usage{
SpatReg_GoF(SRModel_list, SRModel_W_list)
}
\arguments{
\item{SRModel_list}{List of estimated spatial or non-spatial regression model of class \code{lm} or \code{Sarlm} (see package \code{spatialreg} for details.)}

\item{SRModel_W_list}{List of \code{listw} objects (see package \code{spdep} for details) containing the spatial weights for the spatial autoregressive component for the G groups.}
}
\value{
A \code{matrix} containing 15 goodness-of-fit indices (e.g., likelihood-based information criteria, Wald and LR test, Moran's I statistic) for the list of models given as a input in \code{SRModel_list}.
}
\description{
Computes a set of goodness-of-fit indices (e.g., likelihood-based information criteria, Wald and LR test, Moran's I statistic) for a given spatial regression model of class \code{lm} or \code{Sarlm} as defined in package \code{spatialreg}.
The function can be applied to the output of any SCSR model and contained in the \code{ClusterFitModels} output of \code{SCSR_Estim} function.
}
\examples{
data(Data_RC_PM_RM_JABES2024, package="SCDA")
SCSAR <- SCSR_Estim(Formula = "Gini_SO ~ GDPPC_PPS2020 + Share_AgroEmp",
                    Data_sf = Data2020, G=3, listW=listW, Type="SCSAR", Phi = 0.50)
reglist <- c(SCSAR$ClusterFitModels[1],SCSAR$ClusterFitModels[2],SCSAR$ClusterFitModels[3])
Wlist <- c(SCSAR$listW_g[1],SCSAR$listW_g[2],SCSAR$listW_g[3])
SpatReg_GoF(SRModel_list = reglist,SRModel_W_list = Wlist)

}
