% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialProcess.R
\name{spatialPreprocess}
\alias{spatialPreprocess}
\title{Preprocess a spatial dataset for SC-MEB}
\usage{
spatialPreprocess(
  sce,
  platform = c("Visium", "ST"),
  n.PCs = 15,
  n.HVGs = 2000,
  skip.PCA = FALSE,
  log.normalize = TRUE,
  assay.type = "logcounts",
  BSPARAM = BiocSingular::ExactParam()
)
}
\arguments{
\item{sce}{SingleCellExperiment to preprocess}

\item{platform}{Spatial sequencing platform. Used to determine spot layout
and neighborhood structure (Visium = hex, ST = square).}

\item{n.PCs}{Number of principal components to compute. We suggest using the
top 15 PCs in most cases.}

\item{n.HVGs}{Number of highly variable genes to run PCA upon.}

\item{skip.PCA}{Skip PCA (if dimensionality reduction was previously
computed.)}

\item{log.normalize}{Whether to log-normalize the input data with scater. May
be omitted if log-normalization previously computed.}

\item{assay.type}{Name of assay in \code{sce} containing normalized counts.
Leave as "logcounts" unless you explicitly pre-computed a different
normalization and added it to \code{sce} under another assay. Note that we
do not recommend running BayesSpace on PCs computed from raw counts.}

\item{BSPARAM}{A \linkS4class{BiocSingularParam} object specifying which
algorithm should be used to perform the PCA. By default, an exact PCA is
performed, as current spatial datasets are generally small (<10,000 spots).
To perform a faster approximate PCA, please specify
\code{FastAutoParam()} and set a random seed to ensure
reproducibility.}
}
\value{
SingleCellExperiment with PCA and SC.MEB metadata
}
\description{
Adds metadata required for downstream analyses, and (optionally) performs PCA
on log-normalized expression of top HVGs.
}
\examples{
## read the simulated data 
data(sce)
platform = "ST"
out = find_neighbors2(sce, platform)
}
