% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SC-MEB.R
\name{selectKPlot}
\alias{selectKPlot}
\title{selectKPlot.}
\usage{
selectKPlot(SCobject, K_set = 2:10, criterion = "BIC", c = 1)
}
\arguments{
\item{SCobject}{is a object generated from SC.MEB function.}

\item{K_set}{is the corresponding K_set used in your previous function SC.MEB.}

\item{criterion}{is a character specifying the criterion for selecting K. The default is BIC, the alternative criterion MBIC can also be used.}

\item{c}{is a positive value in modified BIC. The default is 1.
Here we briefly explain how to choose the parameter c in the modified BIC. In general, For the ST or Visium dataset, it often ranges from 0.4 to 1 while for the MERFISH dataset with large number of cells, it often becomes larger, for example 10,20. Most importantly, SC-MEB is fast, scaling well in terms of sample size, which allow the user to tune the c based on their prior knowledge about the tissues or cells.}
}
\value{
a ggplot2 object.
}
\description{
The function selectKPlot is used to demonstrate the scatter plot of BIC or Modified BIC vs K for selecting the best K.
}
\details{
The function selectKPlot is used to demonstrate the scatter plot of BIC or Modified BIC vs K for selecting the best K.
}
\examples{
y = matrix(rnorm(50, 0, 1), 25,2)
pos = cbind(rep(1:5, each=5), rep(1:5, 5))
Adj_sp = getneighborhood_fast(pos, 1.2)
beta_grid = c(0.5,1)
K_set = 2:3
out = SC.MEB(y, Adj_sp, beta_grid, K_set, TRUE, 2)
selectKPlot(out, K_set)
}
