% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.energy.R
\name{energy}
\alias{energy}
\title{Energy distance}
\usage{
energy(X, Y, p = 2, metric = "euclidean")
}
\arguments{
\item{X}{[matrix or SparseHist] If matrix, dim = ( nrow = n_samples, ncol =
n_features)}

\item{Y}{[matrix or SparseHist] If matrix, dim = ( nrow = n_samples, ncol =
n_features)}

\item{p}{[float] power of energy distance, default is 2.}

\item{metric}{[str or function] metric for pairwise distance, default is
"euclidean", see SBCK::pairwise_distances}
}
\value{
[float] value of distance
}
\description{
Compute Energy distance between two dataset or SparseHist X and Y
}
\examples{
X = base::cbind( stats::rnorm(2000) , stats::rnorm(2000)  )
Y = base::cbind( stats::rnorm(2000,mean=10)  , stats::rnorm(2000) )
bw = base::c(0.1,0.1)
muX = SBCK::SparseHist( X , bw )
muY = SBCK::SparseHist( Y , bw )

## The four are equals
w2 = SBCK::energy(X,Y)
w2 = SBCK::energy(muX,Y)
w2 = SBCK::energy(X,muY)
w2 = SBCK::energy(muX,muY)

}
