% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc.OTC.R
\name{OTC}
\alias{OTC}
\title{OTC (Optimal Transport Correction) method}
\description{
Perform a multivariate bias correction of X0 with respect to Y0.
}
\details{
Joint distribution, i.e. all dependence are corrected.
}
\examples{
## Two bivariate random variables (rnorm and rexp are inverted between ref 
## and bias)
XY = SBCK::dataset_gaussian_exp_2d(2000)
X0 = XY$X0 ## Biased in calibration period
Y0 = XY$Y0 ## Reference in calibration period

## Bin length
bin_width = SBCK::bin_width_estimator( list(X0,Y0) )

## Bias correction
## Step 1 : construction of the class OTC 
otc = SBCK::OTC$new( bin_width ) 
## Step 2 : Fit the bias correction model
otc$fit( Y0 , X0 )
## Step 3 : perform the bias correction, Z0 is the correction of
## X0 with respect to the estimation of Y0
Z0 = otc$predict(X0)

}
\references{
Robin, Y., Vrac, M., Naveau, P., Yiou, P.: Multivariate
            stochastic bias corrections with optimal transport, Hydrol. Earth
            Syst. Sci., 23, 773–786, 2019,
            https://doi.org/10.5194/hess-23-773-2019
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{bin_width}}{[vector or NULL] A vector of lengths of the cells
discretizing R^{numbers of variables}. If NULL, it is estimating
during the fit}

\item{\code{bin_origin}}{[vector or NULL] Coordinate of lower corner of one
cell. If NULL, c(0,...,0) is used}

\item{\code{muX}}{[SparseHist] Histogram of the data from the model}

\item{\code{muY}}{[SparseHist] Histogram of the data from the observations}

\item{\code{ot}}{[OTSolver] Optimal Transport solver, default is the network
simplex}

\item{\code{plan}}{[matrix] The plan computed by the ot solver.}

\item{\code{n_features}}{[integer] Numbers of features}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OTC-new}{\code{OTC$new()}}
\item \href{#method-OTC-fit}{\code{OTC$fit()}}
\item \href{#method-OTC-predict}{\code{OTC$predict()}}
\item \href{#method-OTC-clone}{\code{OTC$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OTC-new"></a>}}
\if{latex}{\out{\hypertarget{method-OTC-new}{}}}
\subsection{Method \code{new()}}{
Create a new OTC object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OTC$new(bin_width = NULL, bin_origin = NULL, ot = SBCK::OTNetworkSimplex$new())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bin_width}}{[vector or NULL] A vector of lengths of the cells
discretizing R^{numbers of variables}. If NULL, it is estimating
during the fit}

\item{\code{bin_origin}}{[vector or NULL] Coordinate of lower corner of one
cell. If NULL, c(0,...,0) is used}

\item{\code{ot}}{[OTSolver] Optimal Transport solver, default is the network
simplex}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `OTC` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OTC-fit"></a>}}
\if{latex}{\out{\hypertarget{method-OTC-fit}{}}}
\subsection{Method \code{fit()}}{
Fit the bias correction method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OTC$fit(Y0, X0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{Y0}}{[matrix: n_samples * n_features] Observations in calibration}

\item{\code{X0}}{[matrix: n_samples * n_features] Model in calibration}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OTC-predict"></a>}}
\if{latex}{\out{\hypertarget{method-OTC-predict}{}}}
\subsection{Method \code{predict()}}{
Predict the correction

Note: Only the center of the bins associated to the corrected points are
returned, but all corrections of the form:
>> bw = otc$bin_width / 2
>> n  = base::prod(base::dim(X0))
>> Z0 = otc$predict(X0)
>> Z0 = Z0 + t(matrix(stats::runif( n = n min = - bw , max = bw ) , ncol = dim(X0)[1] ))
are equivalent for OTC.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OTC$predict(X0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{X0}}{[matrix: n_samples * n_features or NULL] Model in calibration}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[matrix] Return the corrections of X0
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OTC-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OTC-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OTC$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
