% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RbfInter.R
\name{predict.RBFinter}
\alias{predict.RBFinter}
\title{Apply cubic or Gaussian RBF interpolation}
\usage{
\method{predict}{RBFinter}(rbf.model, newdata, ...)
}
\arguments{
\item{rbf.model}{trained RBF model (or set of models), see \code{\link{trainCubicRBF}}
or \code{\link{trainGaussRBF}}}

\item{newdata}{matrix or data frame with d columns. Each row contains a data point
\eqn{x_i,\ i=1,\ldots,n}}

\item{...}{(not used)}
}
\value{
vector of model responses \eqn{s(x_i)}, one element for each data point \eqn{x_i} \cr
                 - or - \cr
                 if \code{rbf.model} is a set of \code{m} models, a \code{(n x m)}-matrix
                 containing in each row the response \eqn{s_j(x_i)} of all models
                 \eqn{j = 1,\ldots,m}  to \eqn{x_i}
}
\description{
Apply cubic or Gaussian RBF interpolation to a set of new data points for d>1.
}
\author{
Wolfgang Konen (\email{wolfgang.konen@fh-koeln.de})
}
\seealso{
\code{\link{trainCubicRBF}}, \code{\link{trainGaussRBF}}, \code{\link{interpRBF}}
}

