% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SACOBRA.R
\docType{package}
\name{SACOBRA-package}
\alias{SACOBRA}
\alias{SACOBRA-package}
\title{Self-adjusting Constrained Optimization with RBF}
\description{
Self-adjusting Constrained Optimization with RBF
}
\details{
\tabular{ll}{
Package: \tab SACOBRA\cr
Type: \tab Package\cr
Version: \tab 0.7\cr
Date: \tab 30.08.2015\cr
License: \tab GPL (>= 2)\cr
LazyLoad: \tab yes\cr
}

SACOBRA is a package for numeric constrained optimization of expensive black-box functions under severely
limited budgets. It is an extension of the COBRA algorithm by Regis (R. Regis: "Constrained
optimization by radial basis function interpolation for high-dimensional expensive black-box
problems with infeasible initial points", Engineering Optimization, Taylor & Francis, 46, p. 218-243, 2013)

These extensions include: \cr
1) A repair algorithm for infeasible solutions, \cr
2) several internal optimizers and several initial design generation methods,  \cr
3) self-adjusting random restart algorithm,  \cr
4) self-adjusting logarithmic transform for objective functions with large output ranges,  \cr
5) range normalization of constraint functions, \cr
6) self-adjusting DRC selection. \cr

SACOBRA performs optimization with a minimum of true function evaluations. It has proven
to work well on probelms with high dimensions (e.g. d=124) and many constraints (e.g. 60).
It is usable for all kind of numeric optimization, but not for combinatorial optimization.

For more details see:\cr
Koch, P.; Bagheri, S.; Konen, W. et al.: "A New Repair Method For Constrained Optimization".
In: Proceedings of the 17th Genetic and Evolutionary Computation Conference, 2015,
\url{http://www.gm.fh-koeln.de/~konen/Publikationen/Koch2015a-GECCO.pdf} \cr
and \cr
Koch, P.; Bagheri, S. et al.: "Constrained Optimization with a Limited Number of Function Evaluations"
In: W. Hoffmann, F. & Huellermeier, E. (Eds.),  Proceedings 24. Workshop Computational Intelligence,
Universitaetsverlag Karlsruhe, 2014, 119-134, \url{http://www.gm.fh-koeln.de/~konen/Publikationen/Koch2014a-GMA-CI.pdf}.

The main entry point functions are \code{\link{cobraInit}} and \code{\link{startCobra}}.
See \code{\link{startCobra}} for an example and \code{\link{cobraInit}} for an overview of adjustable SACOBRA-parameters.
Another example is in \code{\link{multiCOBRA}}.
}
\author{
Samineh Bagheri (\email{Samineh.Bagheri@fh-koeln.de}), Wolfgang Konen (\email{Wolfgang.Konen@fh-koeln.de}), Patrick Koch
}
\references{
\url{http://lwibs01.gm.fh-koeln.de/blogs/ciop/research/monrep/}
}
\keyword{RBF}
\keyword{constraints}
\keyword{optimization}
\keyword{package}

