% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{gammaqInv}
\alias{gammaqInv}
\alias{gammaqInva}
\title{gammaqInv and gammaqInva:  Inverses of normalized gammaq function}
\usage{
gammaqInv(a, q)

gammaqInva(x, q)
}
\arguments{
\item{a}{The numeric 'a' parameter in the upper
incomplete gamma}

\item{q}{The numeric 'q' parameter in the upper
incomplete gamma}

\item{x}{The numeric 'x' parameter in the upper incomplete gamma}
}
\value{
inverse gammaq results
}
\description{
gammaqInv and gammaqInva:  Inverses of normalized gammaq function
}
\details{
With the equation:

q = gammaq(a, x)

The 'gammaqInv' function returns a value 'x' that satisfies the
equation above

The 'gammaqInva' function returns a value 'a' that satisfies the
equation above

NOTE: gammaqInva is slow
}
\examples{

gammaqInv(1:3, 0.5)

gammaqInv(1, 1:3 / 3)

gammaqInv(1:3, 1:3 / 3.1)

gammaqInva(1:3, 1:3 / 3.1)
}
\author{
Matthew L. Fidler
}
