% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventTable.R
\name{add.dosing}
\alias{add.dosing}
\title{Add dosing to eventTable}
\usage{
add.dosing(eventTable, dose, nbr.doses = 1L, dosing.interval = 24,
  dosing.to = 1L, rate = NULL, amount.units = NA_character_,
  start.time = 0, do.sampling = FALSE, time.units = NA_character_, ...)
}
\arguments{
\item{eventTable}{eventTable object}

\item{dose}{numeric scalar, dose amount in \code{amount.units};}

\item{nbr.doses}{integer, number of doses;}

\item{dosing.interval}{required numeric scalar, time between doses
in \code{time.units}, defaults to 24 of \code{time.units="hours"};}

\item{dosing.to}{integer, compartment the dose goes into
(first compartment by default);}

\item{rate}{for infusions, the rate of infusion (default
is \code{NULL}, for bolus dosing;}

\item{amount.units}{optional string indicating the dosing units.
Defaults to \code{NA} to indicate as per the original \code{EventTable}
definition.}

\item{start.time}{required dosing start time;}

\item{do.sampling}{logical, should observation sampling records
be added at the dosing times? Defaults to \code{FALSE}.}

\item{time.units}{optional string indicating the time units.
Defaults to \code{"hours"} to indicate as per the original \code{EventTable} definition.}

\item{...}{Other parameters (ignored)}
}
\value{
eventTable with updated dosing (note the event table will be updated anyway)
}
\description{
This adds a dosing event to the event table.  This is provided for
piping syntax through magrittr
}
\seealso{
\code{\link{eventTable}}, \code{\link{RxODE}}
}
\author{
Matthew L. Fidler
}
