% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_json.R
\name{export_json}
\alias{export_json}
\title{Export experiment data to a JSON file.}
\usage{
export_json(experiment, tracks = "all", file = NULL)
}
\arguments{
\item{experiment}{An \code{rtrack_experiment} object from
\code{\link{read_experiment}}.}

\item{tracks}{Which tracks should be exported. Default, 'all' exports the
entire experiment object. A subset of tracks can be specified using either
numeric indices or a vector of track IDs following usual R standards.}

\item{file}{The file to which the JSON data will be written. If \code{NULL}
(the default), nothing will be written.}
}
\value{
This function invisibly returns the JSON data as a character string.
}
\description{
Creates a representation of the experiment data in the JSON format and
optionally writes this to file.
}
\details{
The exported JSON file contains all the raw data and experiment metadata. The
JSON archive contains exactly the same information as if reading from raw
data. Calculated metrics are not exported, but can be recreated exactly.

A formal description of the JSON format can be found in the schema file at
\url{http://rupertoverall.net/Rtrack/Rtrack_schema_v1.json}.
}
\examples{
require(Rtrack)
experiment.description <- system.file("extdata", "Minimal_experiment.xlsx",
  package = "Rtrack")
experiment <- read_experiment(experiment.description, format = "excel",
  project.dir = system.file("extdata", "", package = "Rtrack"))
tempfile <- file.path(tempdir(), "Minimal_experiment.json") # Temporary file
export_json(experiment, file = tempfile)
imported.experiment <- read_experiment(tempfile, format = "json")
# Experiments are identical except for export timestamp/notes
all.equal(experiment, imported.experiment)
identical(experiment$metrics, imported.experiment$metrics)

}
\seealso{
\code{\link{read_experiment}} to import the JSON file back into R.
}
