% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rprofet.R
\name{WOEClust}
\alias{WOEClust}
\title{Variable Clustering}
\usage{
WOEClust(dat, id, target, num_clusts)
}
\arguments{
\item{dat}{Dataframe containing the WOE binned variables. See 'Details'.}

\item{id}{ID variable.}

\item{target}{A binary target variable.}

\item{num_clusts}{Number of desired clusters.}
}
\value{
A dataframe with the name of all the variables to be clustered,
the corresponding cluster and the information value for each variable.
}
\description{
Function that clusters numeric variables as a form of variable selection.
}
\details{
All the variables that are to be clustered must be numeric or integer type.
}
\examples{
mydata <- ISLR::Default
mydata$ID <- seq(1:nrow(mydata)) ## make an ID variable
mydata$default <- ifelse(mydata$default=="Yes", 1, 0) ## target coded with 1, 0
## create two new variables from bivariate normal
sigma <- matrix(c(45000,-3000,-3000, 55000), nrow = 2)
set.seed(10)
newvars <- MASS::mvrnorm(nrow(mydata),
                     mu=c(1000,200), Sigma=sigma)
mydata$newvar1 <- newvars[,1]
mydata$newvar2 <- newvars[,2]
## Cluster numeric variables by WOEClust
clusters <- WOEClust(dat=mydata, id="ID", target="default", num_clusts=2)
clusters


}
