% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_poetry.R
\name{get.poetry}
\alias{get.poetry}
\title{Primary function for interfacing with the PoetryDB API.}
\usage{
get.poetry(input_term, search_term = NULL, output = NULL,
  output_format = NULL, search_type = NULL)
}
\arguments{
\item{input_term}{The desired input term for searching PoetryDB. Must be one of or any combination of 'author',
'title', 'lines', or 'linecount'.}

\item{search_term}{Relates to the `input_term`. The search term should be relevant to the given input term. If multiple
`input_term` parameters are given, each must have a corresponding `search_term`.}

\item{output}{Can be any or a combination of the input terms {'author', 'title', 'lines', 'linecount'}. If NULL, all
the data returned from PoetryDB by the search will be returned. The output can also be a combination of
the terms, for example, an output of 'author,title,lines,linecount', will return the same result as if the
parameter is set to NULL. An output of 'title,lines', will return the poem's title and text.}

\item{output_format}{If NULL or 'json', the results are returned in JSON format (the PoetryDB API default). If 'text', the
results are returned as a parsed string using the [stringr](https://CRAN.R-project.org/package=stringr) package.}

\item{search_type}{If NULL (default), the search attempts to match any part of the `input_term`. If 'abs', the search
will attempt to find an exact match when searching for the `input_term`.}
}
\value{
Search result returned by the PoetryDB API interface in either a JSON-like object or text (depending on what is
  passed in the `output_format`).
}
\description{
Primary function for interfacing with the PoetryDB API.
}
\examples{
\dontrun{
# Get all of William Shakespeare's poetry by title and lines
shakespeare <- get.poetry('author', 'William Shakespeare', 'title,lines')
# Get all ten books of Paradise Lost written by John Milton by linecount and lines
paradise_lost <- get.poetry('title', 'Paradise Lost', 'linecount,lines')
}
}
