\name{FS.feature.subset.computation}
\alias{FS.feature.subset.computation}
\title{The superreduct computation based on RST and FRST}
\usage{
FS.feature.subset.computation(decision.table,
  method = "greedy.heuristic.superreduct", ...)
}
\arguments{
  \item{decision.table}{a \code{"DecisionTable"} class
  representing the decision table. See
  \code{\link{SF.asDecisionTable}}.}

  \item{method}{a string representing the type of methods.
  See in Section \code{Details}.}

  \item{...}{other parameters corresponding to the chosen
  \code{method}.}
}
\value{
A class \code{"FeatureSubset"}.

See \code{\link{FS.quickreduct.RST}} or
\code{\link{FS.quickreduct.FRST}}.
}
\description{
It is a wrapper function aimed to calculate a superreduct
(i.e., a subset of features).
}
\details{
There exist three methods considered in this function as
follows: \itemize{ \item
\code{"greedy.heuristic.superreduct"}: it is a greedy
heuristic method which employs several quality measurements
based on RST.  See
\code{\link{FS.greedy.heuristic.superreduct.RST}}. \item
\code{"quickreduct.frst"}: it is a feature selection
function based on the fuzzy QuickReduct algorithm on FRST.
See \code{\link{FS.quickreduct.FRST}}. \item
\code{"quickreduct.rst"}: it is a feature selection
function based on the RST QuickReduct algorithm.  See
\code{\link{FS.quickreduct.RST}}. } These methods can be
selected by assigning the parameter \code{method}.
Additionally, \code{\link{SF.applyDecTable}} has been
provided to generate the new decision table.
}
\examples{
###############################################################
## Example 1: generate reduct and new decision table using RST
###############################################################
data(RoughSetData)
decision.table <- RoughSetData$hiring.dt

## generate single superreduct
res.1 <- FS.feature.subset.computation(decision.table,
                  method = "quickreduct.rst")

## generate new decision table according to the reduct
new.decTable <- SF.applyDecTable(decision.table, res.1)

###############################################################
## Example 2: generate reduct and new decision table using FRST
###############################################################
data(RoughSetData)
decision.table <- RoughSetData$housing7.dt

## generate single superreduct
res.2 <- FS.feature.subset.computation(decision.table,
                  method = "quickreduct.frst")

## generate new decision table according to the reduct
new.decTable <- SF.applyDecTable(decision.table, res.2)
}
\seealso{
\code{\link{FS.quickreduct.RST}}.
}

