% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{robyn_response}
\alias{robyn_response}
\title{Response Function}
\usage{
robyn_response(
  robyn_object = NULL,
  select_build = NULL,
  media_metric = NULL,
  select_model = NULL,
  metric_value = NULL,
  dt_hyppar = NULL,
  dt_coef = NULL,
  InputCollect = NULL,
  OutputCollect = NULL,
  quiet = FALSE
)
}
\arguments{
\item{robyn_object}{Character. Path of the \code{Robyn.RDS} object
that contains all previous modeling information.}

\item{select_build}{Integer. Default to the latest model build. \code{select_build = 0}
selects the initial model. \code{select_build = 1} selects the first refresh model.}

\item{media_metric}{A character. Selected media variable for the response.
Must be one value from paid_media_spends, paid_media_vars or organic_vars}

\item{select_model}{Character. A model \code{SolID}. When \code{robyn_object}
is provided, \code{select_model} defaults to the already selected \code{SolID}. When
\code{robyn_object} is not provided, \code{select_model} must be provided with
\code{InputCollect} and \code{OutputCollect}, and must be one of
\code{OutputCollect$allSolutions}.}

\item{metric_value}{Numeric. Desired metric value to return a response for.}

\item{dt_hyppar}{A data.table. When \code{robyn_object} is not provided, use
\code{dt_hyppar = OutputCollect$resultHypParam}. It must be provided along
\code{select_model}, \code{dt_coef} and \code{InputCollect}.}

\item{dt_coef}{A data.table. When \code{robyn_object} is not provided, use
\code{dt_coef = OutputCollect$xDecompAgg}. It must be provided along
\code{select_model}, \code{dt_hyppar} and \code{InputCollect}.}

\item{InputCollect}{List. Contains all input parameters for the model.
Required when \code{robyn_object} is not provided.}

\item{OutputCollect}{List. Containing all model result.
Required when \code{robyn_object} is not provided.}

\item{quiet}{Boolean. Keep messages off?}
}
\value{
List. Response value and plot. Class: \code{robyn_response}.
}
\description{
\code{robyn_response()} returns the response for a given
spend level of a given \code{paid_media_vars} from a selected model
result and selected model build (initial model, refresh model, etc.).
}
\examples{
\dontrun{
# Having InputCollect and OutputCollect results OR robyn_object
# Set your exported model location
robyn_object <- "~/Desktop/MyRobyn.RDS"

# Get marginal response (mResponse) and marginal ROI (mROI) for
# the next 1k on 80k for search_S, when provided the saved
# robyn_object by the robyn_save() function.
spend1 <- 80000
Response1 <- robyn_response(
  robyn_object = robyn_object,
  media_metric = "search_S",
  metric_value = spend1
)$response
# Get ROI for 80k
Response1 / spend1 # ROI for search 80k
# Get response for 81k
spend2 <- spend1 + 1000
Response2 <- robyn_response(
  robyn_object = robyn_object,
  media_metric = "search_S",
  metric_value = spend2
)$response
# Get ROI for 81k
Response2 / spend2 # ROI for search 81k
# Get marginal response (mResponse) for the next 1k on 80k
Response2 - Response1
# Get marginal ROI (mROI) for the next 1k on 80k
(Response2 - Response1) / (spend2 - spend1)

# Example of getting paid media exposure response curves
imps <- 1000000
response_imps <- robyn_response(
  robyn_object = robyn_object,
  media_metric = "facebook_I",
  metric_value = imps
)$response
response_per_1k_imps <- response_imps / imps * 1000
response_per_1k_imps

# Example of getting organic media exposure response curves
sendings <- 30000
response_sending <- robyn_response(
  robyn_object = robyn_object,
  media_metric = "newsletter",
  metric_value = sendings
)$response
response_per_1k_send <- response_sending / sendings * 1000
response_per_1k_send

# Get response for 80k for search_S from the third model refresh
robyn_response(
  robyn_object = robyn_object,
  select_build = 3,
  media_metric = "search_S",
  metric_value = 80000
)

# Get response for 80k for search_S from the a certain model SolID
# in the current model output in the global environment
robyn_response(
  media_metric = "search_S",
  metric_value = 80000,
  select_model = "3_10_3",
  dt_hyppar = OutputCollect$resultHypParam,
  dt_coef = OutputCollect$xDecompAgg,
  InputCollect = InputCollect
)
}
}
