% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneandtrainIntRidge.R
\name{tuneandtrainIntRidge}
\alias{tuneandtrainIntRidge}
\title{Tune and Train Internal Ridge}
\usage{
tuneandtrainIntRidge(
  data,
  maxit = 120000,
  nlambda = 200,
  nfolds = 5,
  seed = 123
)
}
\arguments{
\item{data}{A data frame containing the training data. The first column should be the response variable (factor), 
and the remaining columns should be the predictor variables.}

\item{maxit}{An integer specifying the maximum number of iterations. Default is 120000.}

\item{nlambda}{An integer specifying the number of lambda values to use in the Ridge model. Default is 200.}

\item{nfolds}{An integer specifying the number of folds for cross-validation. Default is 5.}

\item{seed}{An integer specifying the random seed for reproducibility. Default is 123.}
}
\value{
A list containing the best lambda value (`best_lambda`), the final trained model (`best_model`), 
  and the AUC on the training data (`final_auc`).
}
\description{
This function tunes and trains a Ridge classifier using the \code{glmnet} package. The function 
evaluates a sequence of lambda (regularization) values using internal cross-validation and selects 
the best model based on the Area Under the Curve (AUC).
}
\details{
The function trains a logistic Ridge regression model on the training dataset and performs cross-validation 
to select the best lambda value. The lambda value that gives the highest AUC on the training dataset during 
cross-validation is chosen as the best model.
}
\examples{
# Load sample data
data(sample_data_train)

# Example usage
result <- tuneandtrainIntRidge(sample_data_train, maxit = 120000, 
  nlambda = 200, nfolds = 5, seed = 123)
result$best_lambda
result$best_model
result$final_auc
}
