% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endo-test.R
\name{endo.test}
\alias{endo.test}
\title{Endogeneity test in high dimensions}
\usage{
endo.test(
  Y,
  D,
  Z,
  X,
  intercept = TRUE,
  invalid = FALSE,
  method = c("Fast.DeLasso", "DeLasso", "OLS"),
  voting = c("MP", "MaxClique"),
  alpha = 0.05,
  tuning.1st = NULL,
  tuning.2nd = NULL
)
}
\arguments{
\item{Y}{The outcome observation, a vector of length \eqn{n}.}

\item{D}{The treatment observation, a vector of length \eqn{n}.}

\item{Z}{The instrument observation of dimension \eqn{n \times p_z}.}

\item{X}{The covariates observation of dimension \eqn{n \times p_x}.}

\item{intercept}{Whether the intercept is included. (default = \code{TRUE})}

\item{invalid}{If \code{TRUE}, the method is robust to the presence of possibly invalid IVs; If \code{FALSE}, the method assumes all IVs to be valid. (default = \code{FALSE})}

\item{method}{The method used to estimate the reduced form parameters. \code{"OLS"} stands for ordinary least squares, \code{"DeLasso"} stands for the debiased Lasso estimator, and \code{"Fast.DeLasso"} stands for the debiased Lasso estimator with fast algorithm. (default = \code{"Fast.DeLasso"})}

\item{voting}{The voting option used to estimate valid IVs. \code{'MP'} stnads for majority and plurality voting, \code{'MaxClique'} stands for maximum clique in the IV voting matrix. (default = \code{'MP'})}

\item{alpha}{The significance level for the confidence interval. (default = \code{0.05})}

\item{tuning.1st}{The tuning parameter used in the 1st stage to select relevant instruments. If \code{NULL}, it will be generated data-dependently, see Details. (default=\code{NULL})}

\item{tuning.2nd}{The tuning parameter used in the 2nd stage to select valid instruments. If \code{NULL}, it will be generated data-dependently, see Details. (default=\code{NULL})}
}
\value{
\code{endo.test} returns an object of class "endotest", which is a list containing the following components:
   \item{\code{Q}}{The test statistic.}
   \item{\code{Sigma12}}{The estimated covaraince of the regression errors.}
   \item{\code{VHat}}{The set of selected vaild IVs.}
   \item{\code{p.value}}{The p-value of the endogeneity test.}
   \item{\code{check}}{The indicator that \eqn{H_0:\Sigma_{12}=0} is rejected.}
}
\description{
Conduct the endogeneity test with high dimensional and possibly invalid instrumental variables.
}
\details{
When \code{voting = MaxClique} and there are multiple maximum cliques, the null hypothesis is rejected if one of maximum clique rejects the null.
As for tuning parameter in the 1st stage and 2nd stage, if do not specify, for method "OLS" we adopt \eqn{\sqrt{\log n}} for both tuning parameters, and for other methods
we adopt \eqn{\max{(\sqrt{2.01 \log p_z}, \sqrt{\log n})}} for both tuning parameters.
}
\examples{

n = 500; L = 11; s = 3; k = 10; px = 10;
alpha = c(rep(3,s),rep(0,L-s)); beta = 1; gamma = c(rep(1,k),rep(0,L-k))
phi<-(1/px)*seq(1,px)+0.5; psi<-(1/px)*seq(1,px)+1
epsilonSigma = matrix(c(1,0.8,0.8,1),2,2)
Z = matrix(rnorm(n*L),n,L)
X = matrix(rnorm(n*px),n,px)
epsilon = MASS::mvrnorm(n,rep(0,2),epsilonSigma)
D =  0.5 + Z \%*\% gamma + X \%*\% psi + epsilon[,1]
Y = -0.5 + Z \%*\% alpha + D * beta + X \%*\% phi + epsilon[,2]
endo.test.model <- endo.test(Y,D,Z,X,invalid = TRUE)
summary(endo.test.model)


}
\references{
{
Guo, Z., Kang, H., Tony Cai, T. and Small, D.S. (2018), Testing endogeneity with high dimensional covariates, \emph{Journal of Econometrics}, Elsevier, vol. 207(1), pages 175-187. \cr
}
}
