% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFPE.R
\name{step.lmrobdetMM}
\alias{step.lmrobdetMM}
\alias{step.lmrobdet}
\title{Robust stepwise using RFPE}
\usage{
step.lmrobdetMM(
  object,
  scope,
  direction = c("both", "backward", "forward"),
  trace = TRUE,
  keep = NULL,
  steps = 1000,
  whole.path = FALSE
)
}
\arguments{
\item{object}{a robust fit as returned by \code{\link{lmrobdetMM}}}

\item{scope}{either a formula or a list with elements \code{lower} and \code{upper} each of 
which is a formula. The terms in the right-hand-side of \code{lower} are always included 
in the model and the additional terms in the right-hand-side of \code{upper} are the
candidates for inclusion/exclusion from the model. If a single formula is given, it is 
taken to be \code{upper}, and \code{lower} is set to the empty model. The \code{.} operator 
is interpreted in the context of the formula in \code{object}.}

\item{direction}{the direction of stepwise search. Currenly only \code{backward} stepwise 
searches are implemented.}

\item{trace}{logical. If \code{TRUE} information about each step is printed on the screen.}

\item{keep}{a filter function whose input is a fitted model object and the associated AIC statistic, and whose output is arbitrary. Typically keep will select a subset of the components of the object and return them. The default is not to keep anything.}

\item{steps}{maximum number of steps to be performed. Defaults to 1000, which should mean as many as needed.}

\item{whole.path}{if \code{FALSE} (default) variables are dropped until the RFPE fails to improve. If \code{TRUE} the best variable to be dropped is removed, even if this does not improve the RFPE.}
}
\value{
If \code{whole.path == FALSE} the function returns the robust fit as obtained by \code{lmrobdetMM} using the final model. 
If \code{whole.path == TRUE} a list is returned containing the RFPE of each model on the sequence
of submodels. The names of the components of this list are the formulas that correspods to each model.
}
\description{
This function performs stepwise model selection on a robustly fitted
linear model using the RFPE
criterion and the robust regression estimators computed with
\code{\link{lmrobdetMM}}. Only backwards stepwise is currently implemented.
}
\details{
Presently only backward stepwise selection is supported. During each step the 
Robust Final Prediction Error (as computed by the function \code{lmrobdetMM.RFPE}) is 
calculated for the current model and for each sub-model achievable by deleting a 
single term. If the argument \code{whole.path} is \code{FALSE}, the function steps 
to the sub-model with the lowest 
Robust Final Prediction Error or, if the current model has the lowest Robust Final 
Prediction Error, terminates. If the argument \code{whole.path} is \code{TRUE}, the 
function steps through all smaller submodels removing, at each step, the variable 
that most reduces the Robust Final Prediction Error. The scale estimate from \code{object} 
is used to compute the Robust Final Prediction Error throughout the procedure.
}
\examples{
cont <- lmrobdet.control(bb = 0.5, efficiency = 0.85, family = "bisquare")
set.seed(300)
X <- matrix(rnorm(50*6), 50, 6)
beta <- c(1,1,1,0,0,0)
y <- as.vector(X \%*\% beta) + 1 + rnorm(50)
y[1:6] <- seq(30, 55, 5)
for (i in 1:6) X[i,] <- c(X[i,1:3],i/2,i/2,i/2)
Z <- cbind(y,X)
Z <- as.data.frame(Z)
obj <- lmrobdetMM(y ~ ., data=Z, control=cont)
out <- step.lmrobdetMM(obj)

}
\references{
\url{http://www.wiley.com/go/maronna/robust}
}
\seealso{
\code{\link{DCML}}, \code{\link{MMPY}}, \code{\link{SMPY}}
}
\author{
Victor Yohai, \email{victoryohai@gmail.com}, Matias Salibian-Barrera, \email{matias@stat.ubc.ca}
}
