% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WMLlogreg.R
\name{logregWML}
\alias{logregWML}
\alias{WMLlogreg}
\title{Weighted likelihood estimator for the logistic model}
\usage{
logregWML(x0, y, intercept = 1)
}
\arguments{
\item{x0}{p x n matrix of explanatory variables, p is the number of explanatory variables, n is the number of observations}

\item{y}{response vector}

\item{intercept}{1 or 0 indicating if an intercept is included or or not}
}
\value{
A list with the following components:
\item{coefficients}{vector of regression coefficients}
\item{standard.deviation}{standard deviations of the regression coefficient estimators}
\item{fitted.values}{vector with the probabilities of success}
\item{residual.deviances}{residual deviances}
\item{cov}{covariance matrix of the regression estimates}
\item{objective}{value of the objective function at the minimum}
\item{xweights}{vector of zeros and ones used to compute the weighted maimum likelihood estimator}
}
\description{
This function computes a weighted likelihood estimator for the logistic model, where
the weights penalize high leverage observations. In this version the weights are zero or one.
}
\examples{
data(skin)
Xskin <- as.matrix( skin[, 1:2] )
yskin <- skin$vasoconst
skinWML <- logregWML(Xskin, yskin, intercept=1)
skinWML$coeff
skinWML$standard.deviation

}
\references{
\url{http://www.wiley.com/go/maronna/robust}
}
\author{
Victor Yohai
}
