% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCML.R
\name{SMPY}
\alias{SMPY}
\title{SM regression estimator using Pen~a-Yohai candidates}
\usage{
SMPY(mf, y, control, split)
}
\arguments{
\item{mf}{model frame}

\item{y}{response vector}

\item{control}{a list of control parameters as returned by \code{\link{lmrobdet.control}}}

\item{split}{a list as returned by \code{\link{splitFrame}} containing the continuous and
dummy components of the design matrix}
}
\value{
an \code{\link{lmrob}} object witht the M-estimator
obtained starting from the MS-estimator computed with the
Pen~a-Yohai initial candidates. The properties of the final
estimator (efficiency, etc.) are determined by the tuning constants in
the argument \code{control}.
}
\description{
This function computes a robust regression estimator when there
are categorical / dummy explanatory variables. It uses Pen~a-Yohai
candidates for the S-estimator. This function is used
internally by \code{\link{lmrobdetMM}}, and not meant to be used
directly.
}
\references{
\url{http://www.wiley.com/go/maronna/robust}
}
\seealso{
\code{\link{DCML}}, \code{\link{MMPY}}, \code{\link{SMPY}}
}
\author{
Victor Yohai, \email{victoryohai@gmail.com}, Matias Salibian-Barrera, \email{matias@stat.ubc.ca}
}
