% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCML.R
\name{DCML}
\alias{DCML}
\title{DCML regression estimator}
\usage{
DCML(x, y, z, z0, control)
}
\arguments{
\item{x}{design matrix}

\item{y}{response vector}

\item{z}{robust fit as returned by \code{\link{MMPY}} or \code{\link{SMPY}}}

\item{z0}{least squares fit as returned by \code{\link{lm.fit}}}

\item{control}{a list of control parameters as returned by \code{\link{lmrobdet.control}}}
}
\value{
a list with the following components
\item{coefficients}{the vector of regression coefficients}
\item{cov}{the estimated covariance matrix of the DCML regression estimator}
\item{residuals}{the vector of regression residuals from the DCML fit}
\item{scale}{a robust residual (M-)scale estimate}
\item{t0}{the mixing proportion between the least squares and robust regression estimators}
}
\description{
This function computes the DCML regression estimator. This function is used
internally by \code{\link{lmrobdetDCML}}, and not meant to be used
directly.
}
\references{
\url{http://www.wiley.com/go/maronna/robust}
}
\seealso{
\code{\link{DCML}}, \code{\link{MMPY}}, \code{\link{SMPY}}
}
\author{
Victor Yohai, \email{victoryohai@gmail.com}, Matias Salibian-Barrera, \email{matias@stat.ubc.ca}
}
