% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getnlfilename.R
\name{getNlTileZipLclNamePath}
\alias{getNlTileZipLclNamePath}
\title{Constructs the full path used to save/access the compressed downloaded tile}
\usage{
getNlTileZipLclNamePath(nlType, nlPeriod, tileNum)
}
\arguments{
\item{nlType}{the nlType of interest}

\item{nlPeriod}{the nlPeriod in which the tile was created}

\item{tileNum}{the index of the tile as given in nlTileIndex}
}
\value{
a character string filename of the compressed .tgz VIIRS tile
}
\description{
Constructs the full path used to save/access the compressed downloaded tile
    Calls the relevant function for the given nlType
}
\examples{
\dontrun{
Rnightlights:::getNlTileZipLclNamePath("VIIRS", "201401", 1)
 #returns "/dataPath/VIIRS_2014_01_75N180W.tgz"
 }
 
\dontrun{
Rnightlights:::getNlTileZipLclNamePath("OLS", "2004", 1)
 #returns "/dataPath/OLS_2004_00N180W.tar"
 }

}
