% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rte_grade_exams.R
\name{rte.grade.exams}
\alias{rte.grade.exams}
\title{Grade exams built using rte.grade.exams}
\usage{
rte.grade.exams(exam.names, official.names, exam.version, exam.answer.matrix,
  list.build.rdn.exam, question.points = NULL)
}
\arguments{
\item{exam.names}{A character vector with the names of the students, obtained from the test}

\item{official.names}{A character array with the names of the students obtained from the university system (what really counts for registering marks)}

\item{exam.version}{A numeric vector with the version of the exam for each student, obtained from the exam}

\item{exam.answer.matrix}{A matrix with the answers of the students where the rows represent each studend and the columns are the answers to each question}

\item{list.build.rdn.exam}{A list with several information of the random exams (output from rte.build.rdn.text)}

\item{question.points}{A numeric vector with the score for each question (if not available, will assume the naive value of 1/n.question)}
}
\value{
A list with the following items: \describe{
\item{df.grade}{A dataframe with the partial resuts from grading}
  \item{df.final.score}{A dataframe with the final results for each student} }
}
\description{
This function will take as input a list from rte.analize.tex.file and use it
to build pdf files of random exams. See the package vignette for details on
how to use it.
}
\examples{
# define some options
latex.dir.out = 'latexOut' # Name of folder where latex files are going (will create if not exists)
pdf.dir.out = 'PdfOut'     # Name of folder where resulting pdf files are going
f.out <- 'MyRandomTest_'   # Name of pdfs (MyRandomTest_1.pdf, MyRandomTest_2.pdf, ... )
n.test <- 3                # Number of tests to build
n.question <- 4            # Number of questions in each test

# Get latex example from package
f.in <- system.file("extdata", "MyRandomTest.tex", package = "RndTexExams")

# Break latex file into a R list
list.out <- rte.analize.tex.file(f.in,
                                 latex.dir.out = latex.dir.out,
                                 pdf.dir.out = pdf.dir.out)

# Build pdfs
list.build.rdn.exam <- rte.build.rdn.test(list.in = list.out,
                                          f.out = f.out,
                                          n.test = n.test,
                                          n.question = n.question,
                                          latex.dir.out = latex.dir.out,
                                          pdf.dir.out = pdf.dir.out,
                                          do.randomize.questions=TRUE,
                                          do.randomize.answers=TRUE,
                                          do.clean.up = TRUE)

# Grade it!
#' # create some (almost) random names
my.names <- c('John', 'Max','Michael')

# official names from the university system
official.names <- c('John A.', 'Max B.','Michael C.')

# version of the test for each student
ver.test <- seq(1:length(my.names))

# number of simulated questions (same as before)
n.questions <- n.question

# Get the correct answer sheet from previous code
correct.answer.sheet <- list.build.rdn.exam$answer.matrix

# create simulated answers from students (cheat a little bit!)
q.to.cheat <- 2  # get at least 2 questions right!
my.answers <- cbind(correct.answer.sheet[ver.test,1:q.to.cheat],
                    matrix(sample(letters[1:5],
                                  replace = TRUE,
                                  size = length(my.names)*(n.questions-q.to.cheat)),
                           ncol = n.questions-q.to.cheat ))

# grade exams with rte.grade.exams
list.grade <- rte.grade.exams(exam.names = my.names,
                              official.names = official.names,
                              exam.version = ver.test,
                              exam.answer.matrix = my.answers,
                              list.build.rdn.exam = list.build.rdn.exam)

print(list.grade$df.final.score)
}

