\name{surveylist}
\alias{surveylist}
\alias{print.sm_survey}
\title{Get survey list}
\description{Get the list of the user's survey}
\usage{
surveylist(page = NULL, page_size = NULL,
           start_date = NULL, end_date = NULL,
           title = NULL, recipient_email = NULL,
           order_asc = NULL, fields = NULL,
           api_key = getOption('sm_api_key'),
           oauth_token = getOption('sm_oauth_token'), ...)
}
\arguments{
\item{page}{A number indicating which page of results to return.}
\item{page_size}{The number of results to return per API call. Default is 1000.}
\item{start_date}{A start datetime to restrict result to. Any returned surveys must have been created on or after this datetime. Required format is \code{YYYY-MM-DD HH:MM:SS}, implicitly in UTC; if argument is of class \code{POSIXct}, formatting is handled automatically.}
\item{end_date}{An end datetime to restrict result to. Any returned surveys must have been created strictly before this datetime. Required format is \code{YYYY-MM-DD HH:MM:SS}, implicitly in UTC; if argument is of class \code{POSIXct}, formatting is handled automatically.}
\item{title}{A character string containing the title of a survey to search for.}
\item{recipient_email}{A character string containing an email adddress. Only surveys sent to this email will be returned.}
\item{order_asc}{A boolean indicating whether results should be sorted in ascending or descending (the default) order.}
\item{fields}{A character vector containing the names of fields to return in each \code{sm_collector} class object. See Details.}
\item{api_key}{Your API key. By default, retrieved from \code{getOption('sm_api_key')}.}
\item{oauth_token}{Your OAuth 2.0 token, as generated by \code{\link{smlogin}}. By default, retrieved from \code{getOption('sm_oauth_token')}.}
\item{...}{Other arguments passed to \code{\link[httr]{POST}}.}
}
\details{Retrieves the list of surveys available to the user.

The \code{fields} argument accepts one or more of the following values: \code{title}, \code{analysis_url}, \code{preview_url}, \code{date_created}, \code{date_modified}, \code{language_id}, \code{question_count}, \code{num_responses}.
}
\value{A list of objects of class \code{sm_survey}.}
\references{
\url{https://developer.surveymonkey.com/mashery/get_survey_list}
}
\author{Thomas J. Leeper}
%\note{}
%\seealso{}
\examples{
\dontrun{
smlogin()
surveylist()
}
}
%\keyword{}
