% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kdv.R
\name{stkdv}
\alias{stkdv}
\title{Use STKDV}
\usage{
stkdv(
  longitude,
  latitude,
  time,
  bandwidth_s = 1000,
  bandwidth_t = 6,
  row_pixels = 800,
  col_pixels = 640,
  t_pixels = 32
)
}
\arguments{
\item{longitude}{features' longitude}

\item{latitude}{features' latitude}

\item{time}{features' time}

\item{bandwidth_s}{spatial bandwidth}

\item{bandwidth_t}{temporal bandwidth}

\item{row_pixels}{row pixels}

\item{col_pixels}{col pixels}

\item{t_pixels}{time pixels}
}
\value{
stkdv result
}
\description{
Efficient and accurate spatiotemporal kernel density visualization.
}
\examples{
\donttest{
data(hk)
resSTKDV <- stkdv(hk$lon, hk$lat, hk$t, 1000, 6, 800, 640, 32)
}
}
