% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve.R
\name{ig_get_location_feed}
\alias{ig_get_location_feed}
\title{Get Feed of a Location}
\usage{
ig_get_location_feed(location_id, max_id = NULL, ranked_content = TRUE,
  return_df = TRUE, paginate = TRUE, max_pages = 10,
  verbose = FALSE)
}
\arguments{
\item{location_id}{numeric; the unique id to identify a place which can be 
found in the \code{"pk"}, \code{"external_id"}, or \code{"facebook_places_id"} fields 
on other objects returned via the Instagram API}

\item{max_id}{integer; the unique id identifying the oldest post that you 
would want to retrieve in this function call}

\item{ranked_content}{logical; do you want the feed content to be sorted by rank?}

\item{return_df}{logical; do you want to return the results as a \code{tbl_df} 
with one row per entity or as a list with one element per entity?}

\item{paginate}{logical; do you want to paginate through results or just return 
the first page?}

\item{max_pages}{integer; a limit to the number of pages to retrieve from 
paginated endpoints. Instagram feeds have the potential to paginate forever, 
so by default we stop after pulling 10 pages. If you would like more or less 
pages returned, then modify this argument.}

\item{verbose}{logical; do you want informative messages?}
}
\description{
This function filters by location and returns all posts that have the same location
}
\details{
Note that if your location is a "group" (such as a city), the feed will 
include media from multiple locations within that area. But if your
location is a very specific place such as a specific night club, it will usually 
only include media from that exact location.
}
\examples{
\donttest{
# location feed for Paris, France
paris_location_feed <- ig_get_location_feed(6889842)
}
}
\seealso{
\url{https://docs.social-streams.com/article/118-find-instagram-location-id}
}
