% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_pdist2.R
\name{gr.pdist2}
\alias{gr.pdist2}
\title{Pairwise Distance for Two Sets Data on Grassmann Manifold}
\usage{
gr.pdist2(
  input1,
  input2,
  type = c("Intrinsic", "Extrinsic", "Asimov", "Binet-Cauchy", "Chordal",
    "Fubini-Study", "Martin", "Procrustes", "Projection", "Spectral"),
  useR = FALSE
)
}
\arguments{
\item{input1}{either an array of size \eqn{(n\times k\times M)} or a list of length \eqn{M} whose elements are \eqn{(n\times k)} orthonormal basis (ONB) on Grassmann manifold.}

\item{input2}{either an array of size \eqn{(n\times k\times N)} or a list of length \eqn{N} whose elements are \eqn{(n\times k)} orthonormal basis (ONB) on Grassmann manifold.}

\item{type}{type of distance measure. Name of each type is \emph{Case Insensitive} and \emph{hyphen} can be omitted.}

\item{useR}{a logical; \code{TRUE} to use R computations while \code{FALSE} goes everything in C++.}
}
\value{
an \eqn{(M\times N)} matrix of pairwise distances.
}
\description{
For data on grassmann manifold \eqn{x_1,x_2,\ldots,x_M \in Gr(k,n)} and 
\eqn{y_1,y_2,\ldots,y_N \in Gr(k,n)}, compute pairwise distances \eqn{d(x_i,y_j)} via several metrics. The distance type \code{"intrinsic"} corresponds to 
geodesic distance while \code{"extrinsic"} is equivalent to \code{"chordal"} distance.
}
\examples{
## generate a dataset with two types of Grassmann elements
#  group1 : first four columns of (8x8) identity matrix + noise
#  group2 : last  four columns of (8x8) identity matrix + noise

mydata1 = list()
mydata2 = list()
sdval   = 0.25
diag8   = diag(8)
for (i in 1:10){
  mydata1[[i]] = qr.Q(qr(diag8[,1:4] + matrix(rnorm(8*4,sd=sdval),ncol=4)))
}
for (i in 1:10){
  mydata2[[i]] = qr.Q(qr(diag8[,5:8] + matrix(rnorm(8*4,sd=sdval),ncol=4)))
}


\donttest{
## compute and visualize distances for all types
#  we will iterate over all measures
alltypes = c("intrinsic","extrinsic","asimov","binetcauchy",
"chordal","fubinistudy","martin","procrustes","projection","spectral")
ntypes   = length(alltypes)

opar <- par(no.readonly=TRUE)
par(mfrow=c(2,5), pty="s")
for (i in 1:ntypes){
  dmat = gr.pdist2(mydata1, mydata2, type=alltypes[i])
  image(dmat, main=alltypes[i])
}
par(opar)
}

}
\author{
Kisung You
}
