% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_test_cont.R
\name{gof_test_cont}
\alias{gof_test_cont}
\title{This function performs a number of gof tests for continuous data}
\usage{
gof_test_cont(
  x,
  pnull,
  rnull,
  qnull,
  phat,
  TS,
  nbins = c(100, 10),
  rate = 0,
  Range = c(-Inf, Inf),
  B = 5000,
  doMethod = "Default"
)
}
\arguments{
\item{x}{data set}

\item{pnull}{cdf under the null hypothesis}

\item{rnull}{routine to generate data under the null hypothesis}

\item{qnull}{routine to calculate quantiles under null hypothesis}

\item{phat}{function to estimate parameters from the data}

\item{TS}{user supplied function to find test statistics}

\item{nbins}{=c(100, 10) number of bins for chi-square tests}

\item{rate}{=0 rate of Poisson if sample size is random, 0 if sample size is fixed}

\item{Range}{=c(-Inf, Inf) limits of possible observations, if any, for chi-square tests}

\item{B}{=5000  number of simulation runs}

\item{doMethod}{Methods to include in tests}
}
\value{
A list with vectors of test statistics and p values
}
\description{
This function performs a number of gof tests for continuous data
}
\examples{
# Tests to see whether data comes from a standard normal distribution.
pnull = function(x) pnorm(x)
qnull = function(x) qnorm(x)
rnull = function()  rnorm(100)
x = rnorm(100) 
gof_test_cont(x, pnull, rnull, qnull, doMethod="all")
# Tests to see whether data comes from a normal distribution with 
# mean and standard deviation estimated from the data.
pnull = function(x, p=c(0, 1)) pnorm(x, p[1], ifelse(p[2]>0.001, p[2], 0.001))
qnull = function(x, p=c(0, 1)) qnorm(x, p[1],  ifelse(p[2]>0.001, p[2], 0.001))
rnull = function(p=c(0, 1))  rnorm(100, p[1], ifelse(p[2]>0.001, p[2], 0.001))
phat = function(x) c(mean(x), sd(x))
gof_test_cont(x, pnull, rnull, qnull, phat)

}
