% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_power_cont.R
\name{gof_power_cont}
\alias{gof_power_cont}
\title{Find the power of various gof tests for continuous data.}
\usage{
gof_power_cont(
  pnull,
  rnull,
  qnull,
  ralt,
  param_alt,
  phat,
  TS,
  alpha = 0.05,
  Range = c(-Inf, Inf),
  B = c(1000, 1000),
  nbins = c(100, 10),
  rate = 0,
  maxProcessors
)
}
\arguments{
\item{pnull}{function to find cdf under  null hypothesis}

\item{rnull}{function to generate data under  null hypothesis}

\item{qnull}{quantile function (inverse cdf). If missing Wasserstein test can not be done.}

\item{ralt}{function to generate data under  alternative hypothesis}

\item{param_alt}{vector of parameter values for distribution under alternative hypothesis}

\item{phat}{function to estimate parameters from the data}

\item{TS}{user supplied function to find test statistics}

\item{alpha}{=0.05, the level of the hypothesis test}

\item{Range}{=c(-Inf, Inf) limits of possible observations, if any}

\item{B}{=c(1000, 1000), number of simulation runs to find power and null distribution}

\item{nbins}{=c(100,10), number of bins for chi square tests.}

\item{rate}{=0 rate of Poisson if sample size is random, 0 if sample size is fixed}

\item{maxProcessors}{maximum of number of processors to use, 1 if no parallel processing is needed or number of cores-1 if missing}
}
\value{
A numeric matrix of power values.
}
\description{
Find the power of various gof tests for continuous data.
}
\examples{
# Power of tests when null hypothesis specifies the standard normal distribution but 
# true data comes from a normal distribution with mean different from 0.
pnull = function(x) pnorm(x)
qnull = function(x) qnorm(x)
rnull = function()  rnorm(50)
ralt = function(mu)  rnorm(50, mu)
gof_power_cont(pnull, rnull, qnull, ralt, c(0.25, 0.5), B=c(500, 500))
# Power of tests when null hypothesis specifies normal distribution and 
# mean and standard deviation are estimated from the data. 
# Example is not run because it takes several minutes.
# true data comes from a normal distribution with mean different from 0.
pnull = function(x, p=c(0, 1)) pnorm(x, p[1], ifelse(p[2]>0.001, p[2], 0.001))
qnull = function(x, p=c(0, 1)) qnorm(x, p[1],  ifelse(p[2]>0.001, p[2], 0.001))
rnull = function(p=c(0, 1))  rnorm(50, p[1], ifelse(p[2]>0.001, p[2], 0.001))
phat = function(x) c(mean(x), sd(x))
\donttest{gof_power_cont(pnull, rnull, qnull, ralt, c(0, 1), phat, B=c(200, 200), maxProcessor=2)}
}
