\name{fwdmv.object}
\alias{fwdmv.object}
\docType{data}

\title{fwdmv.object}

\description{
An object containing a fitted forward search on multivariate data.  The class attribute is set to \code{fwdmv}.
}

\format{
  An \code{fwdmv.object} is a list with the following elements:

  \describe{
    \item{call}{the matched call.}
    \item{Distances}{a numeric matrix containing the Mahalanobis distances computed during the forward search.}
    \item{Center}{a list of numeric matrices containing the location estimates for each group computed during the forward search.}
    \item{Cov}{a list of numeric matrices containing the covariance matrix estimates (in packed storage) for each group computed during the forward seach).}
    \item{Determinant}{a list of numeric vectors containing the determinants of the covariance matrix estimates for each group computed during the forward search.}
    \item{Unit}{a list of lists of integer vectors containing the subsets during each step of the forward search.}
    \item{groups}{a list of integer vectors containing the user specified tentative groups.}
    \item{n}{an integer, the number of units in the data.}
    \item{p}{an integer, the number of variables in the data.}
    \item{m}{an integer, the number of units in the subset during the first step of the forward search.}
    \item{data}{a numeric matrix containing the data, the dimnames attribute is set to \code{NULL}.}
    \item{data.name}{the name of the data frame or matrix containing the multivariate data set.}
    \item{data.names}{a list of character vectors containing the row and column names of the data.}
    \item{group.names}{a character vector containing the names of the tentative groups.}
    \item{unassigned}{an integer vector containing the indices of the units that do not belong to one of the tentative groups.}
    \item{constrained}{a loigcal value, \code{TRUE} if the forward search was constrained.}
    \item{scaled}{a logical value, \code{TRUE} is scaled Mahalanobis distances were used during the forward search.}
    \item{Max}{a numeric vector contining the maximum Mahalanobis distance in the subset.}
    \item{Mth}{a numeric vector containing the mth overall Mahalanobis distance.}
    \item{Min}{a numeric vector containing the minimum Mahalanobis distance not in the subset.}
    \item{Mpo}{a numeric vector containing the (m+1)th overall Mahalanobis distance.}
    \item{initial}{a logical value, \code{TRUE} if this object was generated by the function \code{fwdmv.init}.}
  }
}

\details{
Class \code{fwdmv} objects are created by the functions \code{\link{fwdmv}}, \code{\link{fwdmv.init}}, and \code{\link{partition}}.  The \code{Rfwdmv} package contains a variety of plot methods for assesing \code{fwdmv} objects.  These methods are listed in the see also section.  Note that there are accessor methods for several elements contained in the \code{fwdmv} object.  When an accessor method exists for a certain element it should be used to retrieve that element in preference to direct reference as the structure of the \code{fwdmv} object is likely to change.
}

\seealso{

  \describe{
    \item{\code{\link{fwdmv.init}}}{fit an ititial multivariate forward search.}
    \item{\code{\link{fwdmv}}}{fit a multivariate forward search with user specified tentative groups.}
  }

  Plot methods for assessing a fitted forward search stored in an \code{fwdmv} object:

  \describe{
    \item{\code{\link{fwdmvPairsPlot}}}{a pairs-like plot.}
    \item{\code{\link{fwdmvQuantilePlot}}}{plot trajectories of entering units over quantiles of the distances in the subset.}
    \item{\code{\link{fwdmvEllipsePlot}}}{a pairs-like plots with the subsets represented by ellipses.}
    \item{\code{\link{fwdmvConfirmPlot}}}{plots the nearest center for unassigned and misclassified units.}
    \item{\code{\link{fwdmvCovariancePlot}}}{a forward plot of the elements of the covariance matrices.}
    \item{\code{\link{fwdmvDeterminantPlot}}}{a forward plot of the determinants of the covariance matrices.}
    \item{\code{\link{fwdmvDistancePlot}}}{a forward plot of the Mahalanobis distances.}
    \item{\code{\link{fwdmvEccentricityPlot}}}{a forward plot of the eccentricity for one biariate ellipse.}
    \item{\code{\link{fwdmvPrincompPlot}}}{a forward plot of the principal components.}
    \item{\code{\link{fwdmvEigenvectorPlot}}}{a forward plot of a user specified eigenvector of the covariance matrice.}
    \item{\code{\link{fwdmvEntryPlot}}}{a forward entry plot.}
    \item{\code{\link{fwdmvGapPlot}}}{a gap plot.}
    \item{\code{\link{fwdmvMinmaxPlot}}}{minimum and maximum distances plot.}
    \item{\code{\link{fwdmvChangePlot}}}{aa forward plot of change in Mahalanobis distance.}
    \item{\code{\link{partition}}}{graphically assign units to groups.}
    \item{\code{\link{fwdmvPartitionPlot}}}{view tentative group.}
  }

  Accessor methods:

  \describe{
    \item{\code{\link{bigunit.fwdmv}}}{subsets represented as a logical matrix.}
    \item{\code{\link{eigenvalues.fwdmv}}}{the eigenvalues of the covariance matrix estimates computed during the forward search.}
    \item{\code{\link{eigenvectors.fwdmv}}}{the eigenvectors of the covariance matrix estimates computed during the forward search.}
  }
}

\examples{
data(fondi.dat)
fondi.1 <- fwdmv(fondi.dat)

#fondi.1 is an fwdmv object.
}

\keyword{datasets}
