% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestry.R
\name{training_data_checker}
\alias{training_data_checker}
\title{Training data check}
\usage{
training_data_checker(
  x,
  y,
  ntree,
  replace,
  sampsize,
  mtry,
  nodesizeSpl,
  nodesizeAvg,
  nodesizeStrictSpl,
  nodesizeStrictAvg,
  minSplitGain,
  maxDepth,
  interactionDepth,
  splitratio,
  OOBhonest,
  doubleBootstrap,
  nthread,
  middleSplit,
  doubleTree,
  linFeats,
  monotonicConstraints,
  groups,
  featureWeights,
  deepFeatureWeights,
  observationWeights,
  customSplitSample,
  customAvgSample,
  customExcludeSample,
  linear,
  scale,
  hasNas,
  naDirection
)
}
\arguments{
\item{x}{A data frame of all training predictors.}

\item{y}{A vector of all training responses.}

\item{ntree}{The number of trees to grow in the forest. The default value is
500.}

\item{replace}{An indicator of whether sampling of training data is with
replacement. The default value is TRUE.}

\item{sampsize}{The size of total samples to draw for the training data. If
sampling with replacement, the default value is the length of the training
data. If sampling without replacement, the default value is two-thirds of
the length of the training data.}

\item{mtry}{The number of variables randomly selected at each split point.
The default value is set to be one-third of the total number of features of the training data.}

\item{nodesizeSpl}{Minimum observations contained in terminal nodes.
The default value is 5.}

\item{nodesizeAvg}{Minimum size of terminal nodes for averaging dataset.
The default value is 5.}

\item{nodesizeStrictSpl}{Minimum observations to follow strictly in terminal nodes.
The default value is 1.}

\item{nodesizeStrictAvg}{The minimum size of terminal nodes for averaging data set to follow when predicting.
No splits are allowed that result in nodes with observations less than this parameter.
This parameter enforces overlap of the averaging data set with the splitting set when training.
When using honesty, splits that leave less than nodesizeStrictAvg averaging
observations in either child node will be rejected, ensuring every leaf node
also has at least nodesizeStrictAvg averaging observations. The default value is 1.}

\item{minSplitGain}{Minimum loss reduction to split a node further in a tree.}

\item{maxDepth}{Maximum depth of a tree. The default value is 99.}

\item{interactionDepth}{All splits at or above interaction depth must be on
variables that are not weighting variables (as provided by the interactionVariables argument).}

\item{splitratio}{Proportion of the training data used as the splitting dataset.
It is a ratio between 0 and 1. If the ratio is 1 (the default), then the splitting
set uses the entire data, as does the averaging set---i.e., the standard Breiman RF setup.
If the ratio is 0, then the splitting data set is empty, and the entire dataset is used
for the averaging set (This is not a good usage, however, since there will be no data available for splitting).}

\item{OOBhonest}{In this version of honesty, the out-of-bag observations for each tree
are used as the honest (averaging) set. This setting also changes how predictions
are constructed. When predicting for observations that are out-of-sample
(using predict(..., aggregation = "average")), all the trees in the forest
are used to construct predictions. When predicting for an observation that was in-sample (using
predict(..., aggregation = "oob")), only the trees for which that observation
was not in the averaging set are used to construct the prediction for that observation.
aggregation="oob" (out-of-bag) ensures that the outcome value for an observation
is never used to construct predictions for a given observation even when it is in sample.
This property does not hold in standard honesty, which relies on an asymptotic
subsampling argument. By default, when OOBhonest = TRUE, the out-of-bag observations
for each tree are resamples with replacement to be used for the honest (averaging)
set. This results in a third set of observations that are left out of both
the splitting and averaging set, we call these the double out-of-bag (doubleOOB)
observations. In order to get the predictions of only the trees in which each
observation fell into this doubleOOB set, one can run predict(... , aggregation = "doubleOOB").
In order to not do this second bootstrap sample, the doubleBootstrap flag can
be set to FALSE.}

\item{doubleBootstrap}{The doubleBootstrap flag provides the option to resample
with replacement from the out-of-bag observations set for each tree to construct
the averaging set when using OOBhonest. If this is FALSE, the out-of-bag observations
are used as the averaging set. By default this option is TRUE when running OOBhonest = TRUE.
This option increases diversity across trees.}

\item{nthread}{Number of threads to train and predict the forest. The default
number is 0 which represents using all cores.}

\item{middleSplit}{Indicator of whether the split value is takes the average of two feature
values. If FALSE, it will take a point based on a uniform distribution
between two feature values. (Default = FALSE)}

\item{doubleTree}{if the number of tree is doubled as averaging and splitting
data can be exchanged to create decorrelated trees. (Default = FALSE)}

\item{linFeats}{A vector containing the indices of which features to split
linearly on when using linear penalized splits (defaults to use all numerical features).}

\item{monotonicConstraints}{Specifies monotonic relationships between the continuous
features and the outcome. Supplied as a vector of length p with entries in
1,0,-1 which 1 indicating an increasing monotonic relationship, -1 indicating
a decreasing monotonic relationship, and 0 indicating no constraint.
Constraints supplied for categorical variable will be ignored.}

\item{groups}{A vector of factors specifying the group membership of each training observation.
these groups are used in the aggregation when doing out of bag predictions in
order to predict with only trees where the entire group was not used for aggregation.
This allows the user to specify custom subgroups which will be used to create
predictions which do not use any data from a common group to make predictions for
any observation in the group. This can be used to create general custom
resampling schemes, and provide predictions consistent with the Out-of-Group set.}

\item{featureWeights}{weights used when subsampling features for nodes above or at interactionDepth.}

\item{deepFeatureWeights}{weights used when subsampling features for nodes below interactionDepth.}

\item{observationWeights}{Denotes the weights for each training observation
that determine how likely the observation is to be selected in each bootstrap sample.
This option is not allowed when sampling is done without replacement.}

\item{customSplitSample}{List of vectors for user-defined splitting observations per tree. The vector at
index i contains the indices of the sampled splitting observations, with replacement allowed, for tree i.
This feature overrides other sampling parameters and must be set in conjunction with customAvgSample.}

\item{customAvgSample}{List of vectors for user-defined averaging observations per tree. The vector at
index i contains the indices of the sampled splitting observations, with replacement allowed, for tree i.
This feature overrides other sampling parameters and must be set in conjunction with customSplitSample.}

\item{customExcludeSample}{An optional list of vectors for user-defined excluded observations per tree. The vector at
index i contains the indices of the excluded observations for tree i. An observation is considered excluded if it does
not appear in the splitting or averaging set and has been explicitly withheld from being sampled for a tree.
Excluded observations are not considered out-of-bag, so when we call predict with aggregation = "oob",
when we predict for an observation, we will only use the predictions of trees in which the
observation was in the customSplitSample (and neither in the customAvgSample nor the customExcludeSample).
This parameter is optional even when customSplitSample and customAvgSample are set.
It is also optional at the tree level, so can have fewer than ntree entries. When given fewer than
ntree entries, for example K, the entries will be applied to the first K trees in the forest and
the remaining trees will have no excludedSamples.}

\item{linear}{Indicator that enables Ridge penalized splits and linear aggregation
functions in the leaf nodes. This is recommended for data with linear outcomes.
For implementation details, see: https://arxiv.org/abs/1906.06463. Default is FALSE.}

\item{scale}{A parameter which indicates whether or not we want to scale and center
the covariates and outcome before doing the regression. This can help with
stability, so by default is TRUE.}

\item{hasNas}{indicates if there is any missingness in x.}

\item{naDirection}{Sets a default direction for missing values in each split
node during training. It test placing all missing values to the left and
right, then selects the direction that minimizes loss. If no missing values
exist, then a default direction is randomly selected in proportion to the
distribution of observations on the left and right. (Default = FALSE)}
}
\value{
A list of parameters after checking the selected parameters are valid.
}
\description{
Check the input to forestry constructor
}
