% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/getInsights.R
\name{getInsights}
\alias{getInsights}
\title{Extract Insights metric from a Facebook page (admin role required)}
\usage{
getInsights(object_id, token, metric, period = "day", n = 5)
}
\arguments{
\item{object_id}{An object (page, post, domain) ID.}

\item{token}{Either a temporary access token created at
\url{https://developers.facebook.com/tools/explorer} or the OAuth token
created with \code{fbOAuth}.}

\item{metric}{The metric wich you want to get values (All metrics are listed
in https://developers.facebook.com/docs/graph-api/reference/v2.1/insights)}

\item{period}{Time intervals to return}

\item{n}{Number of time intervals of metric values to return. Note that all
metrics returned will be multiple of 3, except for lifetime period. Default
n is 5}
}
\description{
\code{getInsights} retrieves information from an owned Facebook page. Note
that you must specify wich metric from insights you need.
}
\examples{
\dontrun{
## See examples for fbOAuth to know how token was created.
## Getting page impressions for Facebook's Facebook Page
## (only owner or admin of page)
 load("fb_oauth")
	insights <- getInsights(object_id="20531316728", token=fb_oauth, metric='page_impressions')
## Getting post impressions for a random Facebook`s page post
## (only owner or admin of page)
 insights <- getInsights(object_id='221568044327801_754789777921289',
     token=fb_oauth, metric='post_impressions', period='days_28')
}
}
\author{
Danilo Silva \email{silvadaniloc@gmail.com}
Eduardo Carvalho \email{eduardooc.86@gmail.com}
}

