% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mice.impute.rfnode.R,
%   R/mice.impute.rfnode.cond.R, R/mice.impute.rfnode.prox.R
\name{mice.impute.rfnode}
\alias{mice.impute.rfnode}
\alias{mice.impute.rfnode.cond}
\alias{mice.impute.rfnode.prox}
\title{Sampling function for multiple imputation based on predicting nodes of
random forests}
\usage{
mice.impute.rfnode(
  y,
  ry,
  x,
  wy = NULL,
  num.trees.node = 10,
  pre.boot = TRUE,
  use.node.cond.dist = TRUE,
  obs.eq.prob = FALSE,
  do.sample = TRUE,
  num.threads = NULL,
  ...
)

mice.impute.rfnode.cond(
  y,
  ry,
  x,
  wy = NULL,
  num.trees = 10,
  pre.boot = TRUE,
  obs.eq.prob = FALSE,
  ...
)

mice.impute.rfnode.prox(
  y,
  ry,
  x,
  wy = NULL,
  num.trees = 10,
  pre.boot = TRUE,
  obs.eq.prob = FALSE,
  ...
)
}
\arguments{
\item{y}{Vector to be imputed}

\item{ry}{Logical vector of length \code{length(y)} indicating the
the subset \code{y[ry]} of elements in \code{y} to which the imputation
model is fitted. The \code{ry} generally distinguishes the observed
(\code{TRUE}) and missing values (\code{FALSE}) in \code{y}.}

\item{x}{Numeric design matrix with \code{length(y)} rows with predictors for
\code{y}. Matrix \code{x} may have no missing values.}

\item{wy}{Logical vector of length \code{length(y)}. A \code{TRUE} value
indicates locations in \code{y} for which imputations are created.}

\item{num.trees.node}{Number of trees to build, default to \code{10}. For
function \code{mice.impute.rfnode} only.}

\item{pre.boot}{Perform bootstrap prior to imputation to get 'proper'
imputation, i.e. accommodating sampling variation in estimating population
regression parameters (see Shah et al. 2014).}

\item{use.node.cond.dist}{If \code{TRUE}, use conditional distribution formed
by predicting nodes of random forest (out-of-bag observations were excluded);
if \code{FALSE}, use proximity-based imputation.}

\item{obs.eq.prob}{If \code{TRUE}, the candidate observations will be sampled
with equal probability.}

\item{do.sample}{If \code{TRUE}, draw samples for missing observations;
if \code{FALSE}, the corresponding observations numbers will be returned.
For testing purposes, and WILL CAUSE ERRORS for the \code{mice} sampler
function.}

\item{num.threads}{Number of threads for parallel computing. The default is
\code{num.threads = NULL} and all the processors available can be used.}

\item{...}{Other arguments to pass down}

\item{num.trees}{Number of trees to build, default to \code{10}.}
}
\value{
Vector with imputed data, same type as \code{y}, and of length
\code{sum(wy)}
}
\description{
Please note that functions with names starting with "mice.impute" are
exported to be visible for the mice sampler functions. Please do not call
these functions directly unless you know exactly what you are doing.

\code{RfNode} imputation methods, adapter for \code{mice} samplers.
These functions can be called by the \code{mice} sampler functions.

\code{mice.impute.rfnode.cond} is for imputation using the conditional formed
by the predicting nodes of random forests. To use this function, set
\code{method = "rfnode.cond"} in \code{mice} function.

\code{mice.impute.rfnode.prox} is for imputation based on proximity measures
from random forests, and provides functionality similar to
\code{mice.impute.rf}. To use this function, set
\code{method = "rfnode.prox"} in \code{mice} function.

\code{mice.impute.rfnode} is the main function for performing imputation, and
both \code{mice.impute.rfnode.cond} and \code{mice.impute.rfnode.prox} call
this function. By default, \code{mice.impute.rfnode} works like
\code{mice.impute.rfnode.cond}.
}
\details{
Users can get more flexibility from \code{mice.impute.rfnode} function,
}
\examples{
# Prepare data: convert categorical variables to factors
nhanes.fix <- nhanes
nhanes.fix[, c("age", "hyp")] <- lapply(nhanes[, c("age", "hyp")], as.factor)

# Using "rfnode.cond" or "rfnode"
impRfNodeCond <- mice(nhanes.fix, method = "rfnode.cond", m = 5,
maxit = 5, maxcor = 1.0, printFlag = FALSE)

# Using "rfnode.prox"
impRfNodeProx <- mice(nhanes.fix, method = "rfnode.prox", m = 5,
maxit = 5, maxcor = 1.0, printFlag = FALSE)

}
\references{
Hong, Shangzhi, et al. "Multiple imputation using chained random forests."
Preprint, submitted April 30, 2020. https://arxiv.org/abs/2004.14823.

Doove, Lisa L., Stef Van Buuren, and Elise Dusseldorp.
"Recursive partitioning for missing data imputation in the presence of
interaction effects."
Computational Statistics & Data Analysis 72 (2014): 92-104.
}
\author{
Shangzhi Hong
}
