% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal_transform.R
\docType{methods}
\name{margtransf}
\alias{margtransf}
\title{Marginal Transformation}
\usage{
margtransf(data, qmarg = rep(0.95, 2), constrainedshape = TRUE)
}
\arguments{
\item{data}{A matrix containing the data on the original margins.}

\item{qmarg}{A vector containing the marginal quantile used to fit the Generalised Pareto Distribution (GPD) for each variable. Default is \code{rep(0.95, 2)}.}

\item{constrainedshape}{Logical. If \code{TRUE} (Default), the estimated shape parameter of the Generalised Pareto Distribution (GPD) is constrained to lie strictly above \code{-1}.}
}
\value{
An object of S4 class \code{margtransf.class}. This object returns the arguments of the function, a slot \code{parameters} containing a matrix with the shape and scale parameters of the Generalised Pareto Distribution (GPD) for each variable, a slot \code{thresh} containing a vector with the threshold \mjeqn{u}{u} above which the GPD is fitted, and a slot \code{dataexp} containing a matrix with the data on standard exponential margins. 

The \code{plot} function takes an object of S4 class \code{margtransf.class}, and a \code{which} argument specifying the type of plot desired (see \strong{Examples}):
\item{\code{"hist"}}{Plots the marginal distributions of the two variables on original and standard exponential margins.}
\item{\code{"ts"}}{Plots the time series of the two variables on original and standard exponential margins.}
\item{\code{"joint"}}{Plots the joint distribution of the two variables on original and standard exponential margins.}
\item{\code{"all"}}{Plots all the above mentioned plots (default).}
}
\description{
Marginal transformation of a  bivariate random vector to standard exponential margins following \insertCite{ColesTawn1991;textual}{ReturnCurves}. Variables within each margin are assumed identically distributed.
}
\details{
\loadmathjax{} Given a threshold value \mjeqn{u}{u}, each stationary random vector 
is transformed by using the empirical cumulative distribution function 
(cdf) below \mjeqn{u}{u}, and a Generalise Pareto Distribution (GPD) fit above \mjeqn{u}{u}.    

The option to constrain \mjeqn{\xi > -1}{} is included as \mjeqn{\xi \leq -1}{} implies that the fitted
upper endpoint of the distribution's support is the maximum data point. This situation is rarely encountered in practice.
}
\examples{
library(ReturnCurves)

data(airdata)

n <- dim(airdata)[1]

margdata <- margtransf(airdata)

# Plots the marginal distributions of X and Y on original vs standard exponential margins
plot(margdata, which = "hist") 

# Plots the time series of X and Y on original vs standard exponential margins
plot(margdata, which = "ts") 

# Plots the joint distribution of X and Y on original vs standard exponential margins
plot(margdata, which = "joint") 

# Plots all the available plots
plot(margdata, which = "all") 

# To see the the S4 object's slots
str(margdata)

# To access the matrix with the data on standard exponential margins
margdata@dataexp

}
\references{
\insertAllCited{}
}
