% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.peaks.R
\name{find.peaks}
\alias{find.peaks}
\title{Function to find the peak-to-peak intervals of a respiratory signal.}
\usage{
find.peaks(
  y,
  Fs,
  lowpass = TRUE,
  freq = 1,
  MovingAv = FALSE,
  W = FALSE,
  filter = TRUE,
  threshold = 0.2
)
}
\arguments{
\item{y}{a numeric vector, with respiratory data for a regularly spaced time series..}

\item{Fs}{a positive value. sampling frequency of airflow signal.}

\item{lowpass}{logical. Whether to use low-pass filtering to preprocess the airflow signal.}

\item{freq}{an optional values. Cut-off frequency of low-pass filter. The default value is 1.}

\item{MovingAv}{logical.Whether to use Moving Average to preprocess the airflow signal.}

\item{W}{an optional values. the windows of Moving Average.  The default value is equal to the sampling frequency Fs.}

\item{filter}{logical.Whether to filter the points of peaks.}

\item{threshold}{an optional value. A threshold is the minimum height difference between the wave crest and wave trough. The default value is 0.2.}
}
\value{
a dataframe for the information of peaks. "PeakIndex" is the position of the peaks and "PeakHeight" is the height of the peaks
}
\description{
function to find the peak-to-peak intervals of a respiratory signal.
}
\examples{
data("TestData") # load Data from TestData dataset
Fs=50 ## sampling frequency is 50Hz
Peaks <- find.peaks(Data[,2],Fs,lowpass=TRUE,freq=1,MovingAv=FALSE,
                    W=FALSE,filter=TRUE,threshold=0.05)
Peaks


}
