% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PubFinder.R
\name{Get.Publication.info}
\alias{Get.Publication.info}
\title{Retrieve all publications related to user-defined search query from PubMed database}
\usage{
Get.Publication.info(
  Searchquery,
  Publicationinfo = c("title", "source", "lastauthor", "pubtype", "pubdate",
    "pmcrefcount"),
  Output = NULL
)
}
\arguments{
\item{Searchquery}{input a text query for example "Bioinformatics", "Bioinformatics or machine learning", "Cancer and drug targets"}

\item{Publicationinfo}{information to be returned from pubmed such paper title, last author, journal or number of citations}

\item{Output}{path to save file containig results returened by the function.}
}
\description{
Retrieve all publications related to user-defined search query from PubMed database
}
\examples{
Publications <- Get.Publication.info(Searchquery = "physics and deep learning and proteomics")

}
\author{
Mohmed Soudy \email{Mohamed.soudy@57357.com} and Ali Mostafa \email{ali.mo.anwar@std.agr.cu.edu.eg}
}
