/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.format;

import com.topologi.diffx.config.DiffXConfig;
import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.format.DiffXFormatter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class MultiplexFormatter
implements DiffXFormatter {
    private final List<DiffXFormatter> formatters;

    public MultiplexFormatter() {
        this.formatters = new ArrayList<DiffXFormatter>();
    }

    public MultiplexFormatter(DiffXFormatter f) {
        this.formatters = new ArrayList<DiffXFormatter>(1);
        this.formatters.add(f);
    }

    public void add(DiffXFormatter f) {
        this.formatters.add(f);
    }

    public void format(DiffXEvent e) throws IOException {
        for (DiffXFormatter f : this.formatters) {
            f.format(e);
        }
    }

    public void insert(DiffXEvent e) throws IOException {
        for (DiffXFormatter f : this.formatters) {
            f.insert(e);
        }
    }

    public void delete(DiffXEvent e) throws IOException, IllegalStateException {
        for (DiffXFormatter f : this.formatters) {
            f.delete(e);
        }
    }

    public void setConfig(DiffXConfig config) {
        for (DiffXFormatter f : this.formatters) {
            f.setConfig(config);
        }
    }
}

