% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addFlexTable.R
\name{addFlexTable}
\alias{addFlexTable}
\alias{addFlexTable.docx}
\alias{addFlexTable.pptx}
\title{Insert a FlexTable into a document object}
\usage{
addFlexTable(doc, flextable, ...)

\method{addFlexTable}{docx}(doc, flextable,
  par.properties = parProperties(text.align = "left"), bookmark, ...)

\method{addFlexTable}{pptx}(doc, flextable, offx, offy, width, height, ...)
}
\arguments{
\item{doc}{document object}

\item{flextable}{the \code{FlexTable} object}

\item{...}{further arguments passed to other methods}

\item{par.properties}{paragraph formatting properties of the paragraph that contains the table.
An object of class \code{\link{parProperties}}. Only alignment will be used, if you'd
like to add space around a table, specify padding on preceding and or
following paragraph.}

\item{bookmark}{a character vector specifying bookmark id (where to put the table).
If provided, table will be add after paragraph that contains the bookmark.
If not provided, table will be added at the end of the document.}

\item{offx}{optional, x position of the shape (top left position of the bounding box) in inches. See details.}

\item{offy}{optional, y position of the shape (top left position of the bounding box) in inches. See details.}

\item{width}{optional, width of the shape in inches. See details.}

\item{height}{optional, height of the shape in inches. See details.}
}
\value{
a document object
}
\description{
Insert a FlexTable into a document object

FlexTable can be manipulated so that almost any formatting can be specified. See
\code{\link{FlexTable}} for more details.
}
\details{
When document is a \code{pptx} object, two positioning methods are available.

If arguments offx, offy, width, height are missing, position and dimensions
will be defined by the width and height of the next available shape of the slide. This
dimensions can be defined in the layout of the PowerPoint template used to create
the \code{pptx} object.

If arguments offx, offy, width, height are provided, they become position and
dimensions of the new shape.
}
\examples{

options( "ReporteRs-fontsize" = 11 )
\donttest{
ft_obj <- vanilla.table(mtcars)
}
\donttest{
# docx example -----
doc = docx( )
doc = addFlexTable( doc, flextable = ft_obj )
writeDoc( doc, file = "add_ft_ex.docx" )
}

\donttest{
# pptx example -----
doc = pptx( )
doc = addSlide( doc, slide.layout = "Title and Content" )
doc = addFlexTable( doc, flextable = ft_obj )
writeDoc( doc, file = "add_ft_ex.pptx" )
}

}
\seealso{
\code{\link{FlexTable}}, \code{\link{docx}}
, \code{\link{pptx}}
}

