/*
 * Decompiled with CFR 0.152.
 */
package org.lysis.reporters.tables;

import java.math.BigInteger;
import java.util.LinkedHashMap;
import javax.xml.bind.JAXBElement;
import org.docx4j.dml.CTTableRow;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;
import org.docx4j.wml.CTHeight;
import org.docx4j.wml.STHeightRule;
import org.docx4j.wml.Tr;
import org.docx4j.wml.TrPr;
import org.lysis.reporters.tables.FlexCell;
import org.lysis.reporters.tools.DocComponent;
import org.lysis.reporters.tools.HTML4R;

public class FlexRow
extends DocComponent
implements HTML4R {
    private LinkedHashMap<Integer, FlexCell> cellList = new LinkedHashMap();
    private int rowheight;

    public FlexRow() {
        this.rowheight = -1;
    }

    public FlexRow(int height) {
        this.rowheight = height;
    }

    public void add(FlexCell fc) {
        this.cellList.put(this.size(), fc);
    }

    public void add(FlexCell fc, int i) {
        this.cellList.put(i, fc);
    }

    public int size() {
        return this.cellList.size();
    }

    public int weight() {
        int out = 0;
        if (this.size() > 0) {
            int i = 0;
            while (i < this.size()) {
                out += this.cellList.get(i).getColspan();
                ++i;
            }
        }
        return out;
    }

    public int rowHeight() {
        return this.rowheight;
    }

    public FlexCell getCell(int index) {
        return this.cellList.get(index);
    }

    public boolean hasCell(int index) {
        return this.cellList.containsKey(index);
    }

    public int getCellIDCellAt(int index) {
        int cell_id = 0;
        int colspan_curr = 0;
        while (true) {
            if (this.hasCell(cell_id)) {
                colspan_curr += this.getCell(cell_id).getColspan();
            }
            if (colspan_curr > index) break;
            ++cell_id;
        }
        return cell_id;
    }

    public boolean hasCellAt(int index) {
        int cell_id = 0;
        int colspan_curr = 0;
        while (true) {
            if (this.hasCell(cell_id)) {
                colspan_curr += this.getCell(cell_id).getColspan();
            }
            if (colspan_curr > index) {
                return true;
            }
            if (!this.hasCell(cell_id + 1)) {
                return false;
            }
            ++cell_id;
        }
    }

    public String toString() {
        String out = "";
        if (this.size() > 0) {
            int i = 0;
            while (i < this.size()) {
                out = String.valueOf(out) + this.cellList.get(i).toString();
                ++i;
            }
        }
        return out;
    }

    @Override
    public String getHTML() {
        String out = "<tr>";
        int i = 0;
        while (i < this.size()) {
            out = String.valueOf(out) + this.cellList.get(i).getHTML();
            ++i;
        }
        out = String.valueOf(out) + "</tr>";
        return out;
    }

    public Tr getTr() throws Exception {
        Tr workingRow = new Tr();
        boolean ishoriz = true;
        int i = 0;
        while (i < this.size()) {
            this.cellList.get(i).setNumberingDefinitionsPart(this.ndp);
            this.cellList.get(i).setOrderedNumID(this.ordered_num_id);
            this.cellList.get(i).setUnorderedNumID(this.unordered_num_id);
            this.cellList.get(i).setDOCXMLPackage(this.getDOCXMLPackage());
            this.cellList.get(i).getParagraphsSection().getParProperties().setUnorderedNumid(this.unordered_num_id);
            this.cellList.get(i).getParagraphsSection().getParProperties().setOrderedNumid(this.ordered_num_id);
            workingRow.getContent().add(this.cellList.get(i).getTc());
            if (!this.cellList.get(i).horizontalText()) {
                ishoriz = false;
            }
            ++i;
        }
        if (this.rowheight > 0 && !ishoriz) {
            CTHeight ctHeight = new CTHeight();
            ctHeight.setHRule(STHeightRule.AT_LEAST);
            ctHeight.setVal(BigInteger.valueOf(this.rowheight * 20));
            JAXBElement jaxbElement = Context.getWmlObjectFactory().createCTTrPrBaseTrHeight(ctHeight);
            TrPr trPr = new TrPr();
            trPr.getCnfStyleOrDivIdOrGridBefore().add(jaxbElement);
            workingRow.setTrPr(trPr);
        }
        return workingRow;
    }

    public CTTableRow getCTTableRow(SlidePart slidePart) throws Exception {
        CTTableRow workingRow = new CTTableRow();
        boolean ishoriz = true;
        int i = 0;
        while (i < this.size()) {
            FlexCell temp = this.cellList.get(i);
            temp.setPPTXSlidePart(slidePart);
            if (!temp.horizontalText()) {
                ishoriz = false;
            }
            workingRow.getTc().add(temp.getCTTableCell());
            if (temp.getColspan() > 1) {
                int p = 1;
                while (p < temp.getColspan()) {
                    FlexCell temp1 = temp.clone();
                    temp1.setColspan(0);
                    workingRow.getTc().add(temp1.getCTTableCell());
                    ++p;
                }
            }
            ++i;
        }
        if (this.rowheight > 0 && !ishoriz) {
            workingRow.setH((long)(this.rowheight * 12700));
        }
        return workingRow;
    }

    @Override
    public String getCSS() {
        return "";
    }

    @Override
    public String getJS() {
        return "";
    }

    @Override
    public boolean hasJS() {
        return false;
    }

    @Override
    public boolean hasHTML() {
        return true;
    }

    @Override
    public boolean hasCSS() {
        return false;
    }
}

