\name{addRScript.pptx}
\alias{addRScript.pptx}
\title{Add R script into a pptx object}
\usage{
\method{addRScript}{pptx}(doc, rscript, file, text, append = FALSE, ...)
}
\arguments{
  \item{doc}{\code{\link{pptx}} object where expressions
  have to be added}

  \item{file}{R script file. Not used if text or rscript is
  provided.}

  \item{text}{character vector. The text to parse. Not used
  if file or rscript is provided.}

  \item{rscript}{an object of class \code{RScript}. Not
  used if file or text is provided.}

  \item{append}{boolean default to FALSE. If TRUE,
  paragraphs will be appened in the current shape instead
  of beeing sent into a new shape. Paragraphs can only be
  appended on shape containing paragraphs (i.e. you can not
  add paragraphs after a FlexTable).}

  \item{...}{further arguments, not used.}
}
\value{
an object of class \code{\link{pptx}}.
}
\description{
Add R script into a \code{\link{pptx}} object.
}
\details{
You have to one of the following argument: file or text or
rscript.
}
\examples{
\donttest{
doc.filename = "addRScript_example.pptx"
# Create a new document
doc = pptx( title = "title" )
doc = addSlide( doc, slide.layout = "Title and Content" )
an_rscript = RScript( text = "ls()
x = rnorm(10)", par.properties = parProperties() )
doc = addRScript(doc, an_rscript )

# Write the object
writeDoc( doc, file = doc.filename )
}
}
\seealso{
\code{\link{pptx}}, \code{\link{addRScript}}
}

