% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duane.R
\name{duane}
\alias{duane}
\title{Duane Analysis}
\usage{
duane(times, failures, conf.level = 0.95)
}
\arguments{
\item{times}{A numeric vector of cumulative failure times.}

\item{failures}{A numeric vector of the number of failures at each corresponding time in \code{times}.}

\item{conf.level}{Confidence level for the confidence bounds (default: \code{0.95}).}
}
\value{
A list of class \code{"duane"} containing:
\item{model}{The fitted \code{lm} object.}
\item{logLik}{The log-likelihood of the fitted model.}
\item{AIC}{Akaike Information Criterion.}
\item{BIC}{Bayesian Information Criterion.}
\item{conf.level}{The confidence level.}
\item{Cumulative_Time}{The cumulative operating times.}
\item{Cumulative_MTBF}{The cumulative mean time between failures.}
\item{Fitted_Values}{The fitted values on the MTBF scale.}
\item{Confidence_Bounds}{Matrix of fitted values and confidence bounds on the MTBF scale.}
}
\description{
This function performs a Duane analysis (1962) \url{doi:10.1109/TA.1964.4319640}
on failure data by fitting a log-log linear regression of cumulative MTBF
versus cumulative time.
}
\examples{
times <- c(100, 200, 300, 400, 500)
failures <- c(1, 2, 1, 3, 2)
fit <- duane(times, failures, conf.level = 0.90)
print(fit)

}
\seealso{
Other Duane functions: 
\code{\link{plot.duane}()},
\code{\link{print.duane}()}
}
\concept{Duane functions}
