% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DGM_bounds.R
\name{DGM_bounds}
\alias{DGM_bounds}
\title{This function compute the DGM bounds for all the different coefficients.}
\usage{
DGM_bounds(
  Ldata,
  Rdata,
  values,
  sam0,
  refs0,
  out_var,
  nc_var,
  c_var = NULL,
  constraint = NULL,
  nc_sign = NULL,
  c_sign = NULL,
  nbCores = 1,
  eps_default = 0.5,
  nb_pts = 1,
  Bsamp = 1000,
  grid = 30,
  weights_x = NULL,
  weights_y = NULL,
  outside = FALSE,
  meth = "adapt",
  modeNA = FALSE,
  version = "first",
  version_sel = "first",
  alpha = 0.05,
  projections = FALSE,
  R2bound = NULL,
  values_sel = NULL,
  ties = FALSE,
  mult = NULL,
  seed = 2131
)
}
\arguments{
\item{Ldata}{dataset containing (Y,Xc) where Y is the outcome, Xc are potential common regressors.}

\item{Rdata}{dataset containing (Xnc,Xc) where Xnc are the non commonly observed regressors, Xc are potential common regressors.}

\item{values}{the different unique points of support of the common regressor Xc.}

\item{sam0}{the directions q to compute the radial function.}

\item{refs0}{indicating the positions in the vector values corresponding to the components of betac.}

\item{out_var}{label of the outcome variable Y.}

\item{nc_var}{label of the non commonly observed regressors Xnc.}

\item{c_var}{label of the commonly observed regressors Xc.}

\item{constraint}{a vector indicating the different constraints in a vector of the size of X_c indicating the type of constraints, if any on f(X_c) : "concave", "concave", "nondecreasing", "nonincreasing", "nondecreasing_convex", "nondecreasing_concave",  "nonincreasing_convex", "nonincreasing_concave", or NULL for none. Default is NULL, no contraints at all.#' @param nc_sign if sign restrictions on the non-commonly observed regressors Xnc: -1 for a minus sign, 1 for a plus sign, 0 otherwise. Default is NULL, i.e. no constraints.}

\item{nc_sign}{sign restrictions on the non-commonly observed regressors Xnc: -1 for a minus sign, 1 for a plus sign, 0 otherwise. Default is NULL, i.e. no constraints.}

\item{c_sign}{sign restrictions on the commonly observed regressors: -1 for a minus sign, 1 for a plus sign, 0 otherwise. Default is NULL, i.e. no constraints.}

\item{nbCores}{number of cores for the parallel computation. Default is 1.}

\item{eps_default}{If grid =NULL, then epsilon is taken equal to eps_default.}

\item{nb_pts}{the constant C in DGM for the epsilon_0, the lower bound on the grid for epsilon, taken equal to nb_pts*ln(n)/n. Default is 1 without regressors Xc, 3 with Xc.}

\item{Bsamp}{the number of bootstrap/subsampling replications. Default is 1000.}

\item{grid}{the number of points for the grid search on epsilon. Default is 30. If NULL, then epsilon is taken fixed equal to kp.}

\item{weights_x}{the sampling weights for the dataset (Xnc,Xc). Default is NULL.}

\item{weights_y}{the sampling weights for the dataset (Y,Xc). Default is NULL.}

\item{outside}{if TRUE indicates that the parallel computing has been launched outside of the function. Default is FALSE.}

\item{meth}{the method for the choice of epsilon, either "adapt", i.e. adapted to the direction or "min" the minimum over the directions. Default is "adapt".}

\item{modeNA}{indicates if NA introduced if the interval is empty. Default is FALSE.}

\item{version}{version of the computation of the ratio, "first" indicates no weights, no ties, same sizes of the two datasets; "second" otherwise. Default is "second".}

\item{version_sel}{version of the selection of the epsilon, "first" indicates no weights, no ties, same sizes of the two datasets; "second" otherwise. Default is "second".}

\item{alpha}{for the level of the confidence region. Default is 0.05.}

\item{projections}{if FALSE compute the identified set along some directions or the confidence regions. Default is FALSE}

\item{R2bound}{the lower bound on the R2 of the long regression if any. Default is NULL.}

\item{values_sel}{the selected values of Xc for the conditioning. Default is NULL.}

\item{ties}{Boolean indicating if there are ties in the dataset. Default is FALSE.}

\item{mult}{a list of multipliers of our selected epsilon to look at the robustness of the point estimates with respect to it. Default is NULL}

\item{seed}{set a seed to fix the subsampling replications}
}
\value{
a list containing, in order:
 - ci : a list with all the information on the confidence intervals

    * upper: upper bound of the confidence interval on the radial function S in the specified direction at level alpha, possibly with sign constraints

    * lower: lower bound upper bound of the confidence interval on the radial function S, possibly with sign constraints

    * unconstr: confidence interval on the radial function S, without sign constraints

    * If common regressors, upper_agg, lower_agg, and unconstr_agg reports the same values but aggregated over the values of Xc (see the parameter theta0 in the paper)

    * betac_ci: confidence intervals on each coefficients related to the common regressor, possibly with sign constraints

    * betac_ci_unc: confidence intervals on each coefficients related to the common regressor without sign constraints

    If projection is TRUE:

       * support: confidence bound on the support function in each specified direction

 - point : a list with all the information on the point estimates

    * upper: the upper bounds on betanc, possibly with sign constraints

    * lower: the lower bounds on betanc, possibly with sign constraints

    * unconstr: bounds on betanc without sign constraints

    * If common regressors, upper_agg, lower_agg, and unconstr_agg reports the same values but aggregated over the values of Xc (see the parameter theta0 in the paper)

    * betac_pt: bounds on betanc, possibly with sign constraints

    * betac_pt_unc: bounds on betanc without sign constraints
     If projection ==TRUE:

    * support: point estimate of the support function in each specified direction

 - epsilon : the values of the selected epsilon(q)
}
\description{
This function compute the DGM bounds for all the different coefficients.
}
\examples{
n=200
Xnc_x = rnorm(n,0,1.5)
Xnc_y = rnorm(n,0,1.5)
epsilon = rnorm(n,0,1)

## true value
beta0 =1
Y = Xnc_y*beta0 + epsilon
out_var = "Y"
nc_var = "Xnc"

# create the datasets
Ldata<- as.data.frame(Y)
colnames(Ldata) <- c(out_var)
Rdata <- as.data.frame(Xnc_x)
colnames(Rdata) <- c(nc_var)
 values = NULL
s= NULL
refs0 = NULL

sam0 <- rbind(-1,1)
eps0 = 0
############# Estimation #############
output <- DGM_bounds(Ldata,Rdata,values,sam0,refs0,out_var,nc_var)
}
