% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AS_bounds.R
\name{AS_bounds}
\alias{AS_bounds}
\title{This function finds the boundary of the identified set in one specified direction using the AS test and Newton's method.}
\usage{
AS_bounds(start, Yp, Xb, N_max = 30, tol = 10^(-4), tuningParam = NULL)
}
\arguments{
\item{start}{the starting points for the bissection method}

\item{Yp}{the observations of the outcome variable.}

\item{Xb}{the observations of the noncommon regressor (possibly conditional on Xc).}

\item{N_max}{the maximal number of iterations. Default is 30.}

\item{tol}{the tolerance of the method. Default is e-4.}

\item{tuningParam}{the list of tuning parameters. For the details see the function "test" in the package RationalExp.}
}
\value{
a list containing, in order:
 -  the value of estimated radial function in this direction
 -  value of the objective function
 -  the number of iterations
}
\description{
This function finds the boundary of the identified set in one specified direction using the AS test and Newton's method.
}
