% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReadPubMed.R
\name{GetPubMedByID}
\alias{GetPubMedByID}
\title{Retrieve citation information from NCBI's Entrez for a set of PubMed IDs}
\usage{
GetPubMedByID(id, db = "pubmed", ...)
}
\arguments{
\item{id}{character vector; PubMed ID's for searching NCBI's Entrez.}

\item{db}{string; Entrez database to search.}

\item{...}{additional parameters to use for the search.
See the Entrez documentation listed in the \emph{References}.}
}
\value{
a BibEntry object.
}
\description{
Uses NCBI's E-Utilities to retrieve bibliographic information given a
vector of PubMed ID's and returns the results as a BibEntry object.
}
\note{
Returned entries will have \code{bibtype} \dQuote{Article} or \dQuote{Book},
unless a collection title is present -- in which case the \code{bibtype} will be
\dQuote{InBook} -- or there is no journal information returned for an article -- in
which case the \code{bibtype} will be \dQuote{Misc}.
}
\examples{
if (interactive() && !httr::http_error("https://eutils.ncbi.nlm.nih.gov/"))
  GetPubMedByID(c("11209037", "21245076"))
}
\references{
\url{https://www.ncbi.nlm.nih.gov/books/NBK25500/}
}
\seealso{
Other pubmed: \code{\link{GetDOIs}},
  \code{\link{GetPubMedRelated}},
  \code{\link{LookupPubMedID}}, \code{\link{ReadCrossRef}},
  \code{\link{ReadPubMed}}
}
\keyword{database}
