% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/M.rec.R
\name{M.rec}
\alias{M.rec}
\alias{P.rec}
\title{Number of records  in M  vectors at each time}
\usage{
M.rec(XM_T, record = "upper")

P.rec(XM_T, record = "upper")
}
\arguments{
\item{XM_T}{A numeric matrix.}

\item{record}{A character string indicating the type of record to be calulated,  "upper" or "lower".}
}
\value{
A vector with the number (proportion in the case of  \code{P.rec}) of records at each time (row).
}
\description{
This function calculates the number of records at each time  \eqn{t}  in a set of \eqn{M} vectors.
}
\details{
Given  a matrix  formed by  \eqn{M} vectors (columns),  measured at  \eqn{T}  times  (rows), this function  calculates
 the number of records  in the \eqn{M} vectors at each  observed time \eqn{t}.

 Summaries for both upper and lower  records can be calculated.

 The function \code{P.rec}  is equivalent, but calculates the proportion of records at each time, that is the ratio:  \eqn{(number of records)/M}.
 This proportion is an estimation of the probability of record at that time.
}
\examples{
Y1<-c(1,5,3,6,6,9,2)
Y2<-c(10,5,3,6,6,9,2)
Y3<-c(5,7,3,6,19,2,20)
M.rec(cbind(Y1,Y2,Y3))
M.rec(ZaragozaSeries)
P.rec(ZaragozaSeries, record = 'lower')
}
\seealso{
\code{\link{I.rec}},  \code{\link{N.rec}}, \code{\link{value.rec}}
}
