% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateN.r
\name{estimateN}
\alias{estimateN}
\title{Abundance point estimates}
\usage{
estimateN(
  dfunc,
  data,
  area = NULL,
  surveyedSides,
  lengthColumn,
  control = RdistanceControls()
)
}
\arguments{
\item{dfunc}{An estimate distance function (see \code{dfuncEstim}).}

\item{data}{A data frame containing distance observations, transects, 
and lengths.  This data frame must have a column named 'siteID' that identifies
unique sites (transects or points). If observations were made on  line-transects, this 
data frame must also have a column named 
by the \code{lengthColumn} parameter that contains transect lengths. NA
length transects are accepted and are dropped when computing total 
transect length. Only observations on non-NA-length transects are toward density.}

\item{area}{A scalar containing the total area of 
inference. Commonly, this is study area size.  
If \code{area} is NULL (the default), 
\code{area} will be set to 1 square unit of the output units and this
produces abundance estimates equal density estimates. 
If \code{area} is not NULL, it must have measurement units 
assigned by the \code{units} package. 
The units on \code{area} must be convertible
to squared output units. Units 
on \code{area} must be two-dimensional. 
For example, if output units are "foo", 
units on area must be convertible to "foo^2" by the \code{units}
package. 
Units of "km^2", "cm^2", "ha", "m^2", "acre", "mi^2", and many
others are acceptable.}

\item{surveyedSides}{The number of sides of the transect that were surveyed. Either 
1 or 2.  Only applies to line transects.}

\item{lengthColumn}{Character string specifying the (single) column in 
\code{siteData} that contains transect lengths. This is ignored if 
\code{pointSurvey} = TRUE. This column must have measurement units.}

\item{control}{A list containing optimization control parameters such 
as the maximum number of iterations, tolerance, the optimizer to use, 
etc.  See the 
\code{\link{RdistanceControls}} function for explanation of each value,
the defaults, and the requirements for this list. 
See examples below for how to change controls.}
}
\value{
A list containing the following components:

   \item{density}{Estimated density in the surveyed area.}
   
   \item{abundance}{Estimated abundance on the study area.}
   
   \item{n.groups}{The number of detections (not individuals, unless all group sizes = 1) 
   used to estimate density and abundance.}
   
   \item{n.seen}{The number of individuals (sum of group sizes) used to 
   estimate density and abundance.}
   
   \item{area}{Total area of inference. Study area size}
   
   \item{surveyedUnits}{Number of surveyed sites.  This is total transect length
   for line-transects and number of points for point-transects. This total transect
   length does not include NA transects.}
   
   \item{surveyedSides}{Number of sides (1 or 2) of transects surveyed. Only relevant for line-transects.}
   
   \item{avg.group.size}{Average group size on non-NA transects}
   
   \item{w}{Strip width. }
   
   \item{pDetection}{Probability of detection.}
   
For line-transects that do not involve covariates, x$density  
is x$n.seen / (x$surveyedSides * x$w * x$pDetection * x$surveyedUnits)
}
\description{
Estimate abundance given a distance function, 
a "merged" data frame containing detections and transect lengths, area, 
and the number of sides surveyed (if line-transects).   
This is called internally by \code{abundEstim}.  Most users will call 
\code{abundEstim} to estimate abundance.
}
\details{
The abundance estimate for line-transect surveys (if no covariates
   are included in the detection function and both sides of the transect 
   were observed) is 
   \deqn{N =\frac{n(A)}{2(ESW)(L)}}{%
         N = n*A / (2*ESW*L)} 
   where \emph{n} is total number of sighted individuals 
  (i.e., \code{sum(dfunc$detections$groupSizes)}), \emph{L} is the total length of 
  surveyed transect (i.e., \code{sum(siteData[,lengthColumn])}),
  and \emph{ESW} is effective strip width
  computed from the estimated distance function (i.e., \code{ESW(dfunc)}).
  If only one side of transects were observed, the "2" in the denominator 
  is not present (or, replaced with a "1"). 
  
  The abundance estimate for point transect surveys (if no covariates are
  included) is 
   \deqn{N =\frac{n(A)}{\pi(ESR^2)(P)}}{%
         N = n*A / ((3.1415)*ESR^2*(P))} 
   where \emph{n} is total number of sighted individuals,
   \emph{P} is the total number of surveyed points, 
   and \emph{ESR} is effective search radius 
   computed from the estimated distance function (i.e., \code{ESR(dfunc)}).

 Setting \code{plot.bs=FALSE} and \code{showProgress=FALSE} 
    suppresses all intermediate output.
}
\seealso{
\code{\link{dfuncEstim}}, \code{\link{abundEstim}}
}
\keyword{model}
