% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F.start.limits.r
\name{F.start.limits}
\alias{F.start.limits}
\title{Set starting values and limits for parameters of Rdistance functions}
\usage{
F.start.limits(
  like,
  expan,
  w.lo,
  w.hi,
  dist,
  covars = NULL,
  pointSurvey = FALSE
)
}
\arguments{
\item{like}{String specifying the likelihood for the distance function.  Possible values are 
"hazrate" for hazard rate likelihood, "halfnorm" for the half 
normal likelihood, "uniform" for the uniform likelihood, 
"negexp" for the negative exponential likelihood, and 
"Gamma" for the gamma likelihood.}

\item{expan}{Number of expansion terms to include. Valid values are 0, 1, ..., 3.}

\item{w.lo}{Lower or left-truncation limit of the distances.  Normally, 0.}

\item{w.hi}{Upper or right-truncation limit of the distances. This is the maximum off-transect distance that could be observed.}

\item{dist}{The vector of observed off-transect distances being analyzed.  This vector is only required for \code{like} = "Gamma" and "halfnorm".}

\item{covars}{Matrix of covariate values.}

\item{pointSurvey}{Boolean. TRUE if point transect data, FALSE if line transect data.}
}
\value{
A list containing the following components
  \item{start}{Vector of reasonable starting values for parameters of the likelihood and expansion terms. }
  \item{lowlimit}{Vector of lower limits for the likelihood parameters and expansion terms.}
  \item{uplimit}{Vector of upper limits for the likelihood parameters and expansion terms.}
  \item{names}{Vector of names for the likelihood parameters and expansion terms.}
}
\description{
Return reasonable starting values and limits (boundaries) for the parameters of 
  distance functions.  Starting values and limits are specified for 
  all likelihoods and expansion terms.  This function is called by 
  other routines in \code{Rdistance}, and is not intended to 
  be called by the user.
}
\details{
The number of parameters to be fitted is 
  \code{expan + 1 + 1*(like \%in\% c("hazrate", "uniform"))}.
  This is the length of all vectors returned in the output list.
}
\examples{
  data(sparrowDetectionData)
  dist <- sparrowDetectionData$dist
  units(dist) <- "m"
  wl <- units::as_units(0, "m")
  wh <- units::as_units(1000, "m")
  
  F.start.limits("uniform", 0, wl, wh, dist)
  F.start.limits("uniform", 1, wl, wh, dist)
  F.start.limits("uniform", 2, wl, wh, dist)
  F.start.limits("uniform", 3, wl, wh, dist)
  
  F.start.limits("halfnorm", 0, wl, wh, dist)
  F.start.limits("halfnorm", 1, wl, wh, dist)
  F.start.limits("halfnorm", 2, wl, wh, dist)
  F.start.limits("halfnorm", 3, wl, wh, dist)
  
  F.start.limits("halfnorm", 0, wl, wh, dist, pointSurvey = TRUE)
  F.start.limits("halfnorm", 1, wl, wh, dist, pointSurvey = TRUE)
  F.start.limits("halfnorm", 2, wl, wh, dist, pointSurvey = TRUE)
  F.start.limits("halfnorm", 3, wl, wh, dist, pointSurvey = TRUE)
  
  F.start.limits("halfnorm", 0, wl, wh, dist, data.frame(A=1, B=2))
  F.start.limits("halfnorm", 1, wl, wh, dist, data.frame(A=1, B=2))
  F.start.limits("halfnorm", 2, wl, wh, dist, data.frame(A=1, B=2))
  F.start.limits("halfnorm", 3, wl, wh, dist, data.frame(A=1, B=2))
  
  F.start.limits("halfnorm", 0, wl, wh, dist, data.frame(A=1, B=2), TRUE)
  F.start.limits("halfnorm", 1, wl, wh, dist, data.frame(A=1, B=2), TRUE)
  F.start.limits("halfnorm", 2, wl, wh, dist, data.frame(A=1, B=2), TRUE)
  F.start.limits("halfnorm", 3, wl, wh, dist, data.frame(A=1, B=2), TRUE)
  
  F.start.limits("hazrate", 0, wl, wh, dist)
  F.start.limits("hazrate", 1, wl, wh, dist)
  F.start.limits("hazrate", 2, wl, wh, dist)
  F.start.limits("hazrate", 3, wl, wh, dist)
  
  F.start.limits("negexp", 0, wl, wh, dist)
  F.start.limits("negexp", 1, wl, wh, dist)
  F.start.limits("negexp", 2, wl, wh, dist)
  F.start.limits("negexp", 3, wl, wh, dist)
  
  F.start.limits("Gamma", 0, wl, wh, dist)
}
\seealso{
\code{\link{dfuncEstim}}
}
\keyword{models}
