% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_SLPE.R
\name{do.slpe}
\alias{do.slpe}
\title{Supervised Locality Pursuit Embedding}
\usage{
do.slpe(
  X,
  label,
  ndim = 2,
  preprocess = c("center", "scale", "cscale", "decorrelate", "whiten")
)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Supervised Locality Pursuit Embedding (SLPE) is a supervised extension of LPE
that uses class labels of data points in order to enhance discriminating power in
its mapping into a low dimensional space.
}
\examples{
\donttest{
## load iris data
data(iris)
X     = as.matrix(iris[,1:4])
label = as.factor(iris$Species)

## compare SLPE with SLPP
out1 <- do.slpp(X, label)
out2 <- do.slpe(X, label)

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2))
plot(out1$Y, col=label, main="SLPP")
plot(out2$Y, col=label, main="SLPE")
par(opar)
}

}
\references{
\insertRef{zheng_supervised_2006}{Rdimtools}
}
\seealso{
\code{\link{do.lpe}}
}
\author{
Kisung You
}
