% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_mle1.R
\name{est.mle1}
\alias{est.mle1}
\title{Maximum Likelihood Esimation with Poisson Process}
\usage{
est.mle1(X, k1 = 10, k2 = 20)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations.}

\item{k1}{minimum neighborhood size, larger than 1.}

\item{k2}{maximum neighborhood size, smaller than \eqn{n}.}
}
\value{
a named list containing containing \describe{
\item{estdim}{estimated intrinsic dimension.}
}
}
\description{
Assuming the density in a hypersphere is constant, authors proposed to build
a likelihood structure based on modeling local spread of information via Poisson Process.
\code{est.mle1} requires two parameters that model the reasonable range of neighborhood size
to reflect inhomogeneity of distribution across data points.
}
\examples{
\dontrun{
## create example data sets with intrinsic dimension 2
X1 = aux.gensamples(dname="swiss")
X2 = aux.gensamples(dname="ribbon")
X3 = aux.gensamples(dname="saddle")

## acquire an estimate for intrinsic dimension
out1 = est.mle1(X1)
out2 = est.mle1(X2)
out3 = est.mle1(X3)

sprintf("* est.mle1 : estimated dimension for 'swiss'  data is \%.2f.",out1$estdim)
sprintf("* est.mle1 : estimated dimension for 'ribbon' data is \%.2f.",out2$estdim)
sprintf("* est.mle1 : estimated dimension for 'saddle' data is \%.2f.",out3$estdim)
}

}
\references{
\insertRef{levina_maximum_2005}{Rdimtools}
}
\author{
Kisung You
}
